/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.WrittenBookContent;
import io.papermc.paper.text.Filtered;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.ChatDeserializer;
import org.bukkit.craftbukkit.v1_21_R3.util.Handleable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperWrittenBookContent(net.minecraft.world.item.component.WrittenBookContent impl) implements WrittenBookContent,
Handleable<net.minecraft.world.item.component.WrittenBookContent>
{
    @Override
    public net.minecraft.world.item.component.WrittenBookContent getHandle() {
        return this.impl;
    }

    public Filtered<String> title() {
        return Filtered.of((Object)this.impl.d().a(), (Object)this.impl.d().b().orElse(null));
    }

    public String author() {
        return this.impl.e();
    }

    public int generation() {
        return this.impl.f();
    }

    public @Unmodifiable List<Filtered<Component>> pages() {
        return MCUtil.transformUnmodifiable(this.impl.a(), page -> Filtered.of((Object)PaperAdventure.asAdventure((IChatBaseComponent)page.a()), (Object)page.b().map(PaperAdventure::asAdventure).orElse(null)));
    }

    public boolean resolved() {
        return this.impl.g();
    }

    static final class BuilderImpl
    implements WrittenBookContent.Builder {
        private final List<Filterable<IChatBaseComponent>> pages = new ObjectArrayList();
        private Filterable<String> title;
        private String author;
        private int generation = 0;
        private boolean resolved = false;

        BuilderImpl(Filtered<String> title, String author) {
            BuilderImpl.validateTitle((String)title.raw());
            if (title.filtered() != null) {
                BuilderImpl.validateTitle((String)title.filtered());
            }
            this.title = new Filterable<String>((String)title.raw(), Optional.ofNullable((String)title.filtered()));
            this.author = author;
        }

        private static void validateTitle(String title) {
            Preconditions.checkArgument((title.length() <= 32 ? 1 : 0) != 0, (String)"Title cannot be longer than %s, was %s", (int)32, (int)title.length());
        }

        private static void validatePageLength(Component page) {
            String flagPage = ChatDeserializer.e(GsonComponentSerializer.gson().serializeToTree(page));
            Preconditions.checkArgument((flagPage.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot have page length more than %s, had %s", (int)Short.MAX_VALUE, (int)flagPage.length());
        }

        public WrittenBookContent.Builder title(String title) {
            BuilderImpl.validateTitle(title);
            this.title = Filterable.a(title);
            return this;
        }

        public WrittenBookContent.Builder filteredTitle(Filtered<String> title) {
            BuilderImpl.validateTitle((String)title.raw());
            if (title.filtered() != null) {
                BuilderImpl.validateTitle((String)title.filtered());
            }
            this.title = new Filterable<String>((String)title.raw(), Optional.ofNullable((String)title.filtered()));
            return this;
        }

        public WrittenBookContent.Builder author(String author) {
            this.author = author;
            return this;
        }

        public WrittenBookContent.Builder generation(int generation) {
            Preconditions.checkArgument((generation >= 0 && generation <= 3 ? 1 : 0) != 0, (String)"generation must be between %s and %s, was %s", (Object)0, (Object)3, (Object)generation);
            this.generation = generation;
            return this;
        }

        public WrittenBookContent.Builder resolved(boolean resolved) {
            this.resolved = resolved;
            return this;
        }

        public WrittenBookContent.Builder addPage(ComponentLike page) {
            Component component = page.asComponent();
            BuilderImpl.validatePageLength(component);
            this.pages.add(Filterable.a(PaperAdventure.asVanilla(component)));
            return this;
        }

        public WrittenBookContent.Builder addPages(List<? extends ComponentLike> pages) {
            for (ComponentLike componentLike : pages) {
                Component component = componentLike.asComponent();
                BuilderImpl.validatePageLength(component);
                this.pages.add(Filterable.a(PaperAdventure.asVanilla(component)));
            }
            return this;
        }

        public WrittenBookContent.Builder addFilteredPage(Filtered<? extends ComponentLike> page) {
            Component raw = ((ComponentLike)page.raw()).asComponent();
            BuilderImpl.validatePageLength(raw);
            Component filtered = null;
            if (page.filtered() != null) {
                filtered = ((ComponentLike)page.filtered()).asComponent();
                BuilderImpl.validatePageLength(filtered);
            }
            this.pages.add(new Filterable<IChatBaseComponent>(PaperAdventure.asVanilla(raw), Optional.ofNullable(filtered).map(PaperAdventure::asVanilla)));
            return this;
        }

        public WrittenBookContent.Builder addFilteredPages(List<Filtered<? extends ComponentLike>> pages) {
            pages.forEach(this::addFilteredPage);
            return this;
        }

        public WrittenBookContent build() {
            return new PaperWrittenBookContent(new net.minecraft.world.item.component.WrittenBookContent(this.title, this.author, this.generation, (List<Filterable<IChatBaseComponent>>)new ObjectArrayList(this.pages), this.resolved));
        }
    }
}

