/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.Fireworks;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.item.component.FireworkExplosion;
import org.bukkit.FireworkEffect;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_21_R3.util.Handleable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperFireworks(net.minecraft.world.item.component.Fireworks impl) implements Fireworks,
Handleable<net.minecraft.world.item.component.Fireworks>
{
    @Override
    public net.minecraft.world.item.component.Fireworks getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<FireworkEffect> effects() {
        return MCUtil.transformUnmodifiable(this.impl.b(), CraftMetaFirework::getEffect);
    }

    public int flightDuration() {
        return this.impl.a();
    }

    static final class BuilderImpl
    implements Fireworks.Builder {
        private final List<FireworkExplosion> effects = new ObjectArrayList();
        private int duration = 0;

        BuilderImpl() {
        }

        public Fireworks.Builder flightDuration(int duration) {
            Preconditions.checkArgument((duration >= 0 && duration <= 255 ? 1 : 0) != 0, (String)"duration must be an unsigned byte ([%s, %s]), was %s", (Object)0, (Object)255, (Object)duration);
            this.duration = duration;
            return this;
        }

        public Fireworks.Builder addEffect(FireworkEffect effect) {
            Preconditions.checkArgument((this.effects.size() + 1 <= 256 ? 1 : 0) != 0, (String)"Cannot have more than %s effects, had %s", (int)256, (int)(this.effects.size() + 1));
            this.effects.add(CraftMetaFirework.getExplosion(effect));
            return this;
        }

        public Fireworks.Builder addEffects(List<FireworkEffect> effects) {
            Preconditions.checkArgument((this.effects.size() + effects.size() <= 256 ? 1 : 0) != 0, (String)"Cannot have more than %s effects, had %s", (int)256, (int)(this.effects.size() + effects.size()));
            MCUtil.addAndConvert(this.effects, effects, CraftMetaFirework::getExplosion);
            return this;
        }

        public Fireworks build() {
            return new PaperFireworks(new net.minecraft.world.item.component.Fireworks(this.duration, (List<FireworkExplosion>)new ObjectArrayList(this.effects)));
        }
    }
}

