/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.Equippable;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.util.Handleable;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.checkerframework.checker.nullness.qual.Nullable;

public record PaperEquippable(net.minecraft.world.item.equipment.Equippable impl) implements Equippable,
Handleable<net.minecraft.world.item.equipment.Equippable>
{
    @Override
    public net.minecraft.world.item.equipment.Equippable getHandle() {
        return this.impl;
    }

    public EquipmentSlot slot() {
        return CraftEquipmentSlot.getSlot(this.impl.a());
    }

    public Key equipSound() {
        return PaperAdventure.asAdventure(this.impl.b().a().a());
    }

    public @Nullable Key assetId() {
        return this.impl.c().map(PaperAdventure::asAdventureKey).orElse(null);
    }

    public @Nullable Key cameraOverlay() {
        return this.impl.d().map(PaperAdventure::asAdventure).orElse(null);
    }

    public @Nullable RegistryKeySet<EntityType> allowedEntities() {
        return this.impl.e().map(set -> PaperRegistrySets.convertToApi(RegistryKey.ENTITY_TYPE, set)).orElse(null);
    }

    public boolean dispensable() {
        return this.impl.f();
    }

    public boolean swappable() {
        return this.impl.g();
    }

    public boolean damageOnHurt() {
        return this.impl.h();
    }

    public Equippable.Builder toBuilder() {
        return new BuilderImpl(this.slot()).equipSound(this.equipSound()).assetId(this.assetId()).cameraOverlay(this.cameraOverlay()).allowedEntities(this.allowedEntities()).dispensable(this.dispensable()).swappable(this.swappable()).damageOnHurt(this.damageOnHurt());
    }

    static final class BuilderImpl
    implements Equippable.Builder {
        private final EnumItemSlot equipmentSlot;
        private Holder<SoundEffect> equipSound = SoundEffects.as;
        private Optional<ResourceKey<EquipmentAsset>> assetId = Optional.empty();
        private Optional<MinecraftKey> cameraOverlay = Optional.empty();
        private Optional<HolderSet<EntityTypes<?>>> allowedEntities = Optional.empty();
        private boolean dispensable = true;
        private boolean swappable = true;
        private boolean damageOnHurt = true;

        BuilderImpl(EquipmentSlot equipmentSlot) {
            this.equipmentSlot = CraftEquipmentSlot.getNMS(equipmentSlot);
        }

        public Equippable.Builder equipSound(Key sound) {
            this.equipSound = PaperAdventure.resolveSound(sound);
            return this;
        }

        public Equippable.Builder assetId(@Nullable Key assetId) {
            this.assetId = Optional.ofNullable(assetId).map(key -> PaperAdventure.asVanilla(EquipmentAssets.a, key));
            return this;
        }

        public Equippable.Builder cameraOverlay(@Nullable Key cameraOverlay) {
            this.cameraOverlay = Optional.ofNullable(cameraOverlay).map(PaperAdventure::asVanilla);
            return this;
        }

        public Equippable.Builder allowedEntities(@Nullable RegistryKeySet<EntityType> allowedEntities) {
            this.allowedEntities = Optional.ofNullable(allowedEntities).map(set -> PaperRegistrySets.convertToNms(Registries.z, BuiltInRegistries.BUILT_IN_CONVERSIONS.lookup(), set));
            return this;
        }

        public Equippable.Builder dispensable(boolean dispensable) {
            this.dispensable = dispensable;
            return this;
        }

        public Equippable.Builder swappable(boolean swappable) {
            this.swappable = swappable;
            return this;
        }

        public Equippable.Builder damageOnHurt(boolean damageOnHurt) {
            this.damageOnHurt = damageOnHurt;
            return this;
        }

        public Equippable build() {
            return new PaperEquippable(new net.minecraft.world.item.equipment.Equippable(this.equipmentSlot, this.equipSound, this.assetId, this.cameraOverlay, this.allowedEntities, this.dispensable, this.swappable, this.damageOnHurt));
        }
    }
}

