/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.BannerPatternLayers;
import io.papermc.paper.datacomponent.item.BlockItemDataProperties;
import io.papermc.paper.datacomponent.item.BundleContents;
import io.papermc.paper.datacomponent.item.ChargedProjectiles;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.DamageResistant;
import io.papermc.paper.datacomponent.item.DeathProtection;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import io.papermc.paper.datacomponent.item.Enchantable;
import io.papermc.paper.datacomponent.item.Equippable;
import io.papermc.paper.datacomponent.item.Fireworks;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.ItemAdventurePredicate;
import io.papermc.paper.datacomponent.item.ItemArmorTrim;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import io.papermc.paper.datacomponent.item.ItemContainerContents;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.JukeboxPlayable;
import io.papermc.paper.datacomponent.item.LodestoneTracker;
import io.papermc.paper.datacomponent.item.MapDecorations;
import io.papermc.paper.datacomponent.item.MapId;
import io.papermc.paper.datacomponent.item.MapItemColor;
import io.papermc.paper.datacomponent.item.PaperBannerPatternLayers;
import io.papermc.paper.datacomponent.item.PaperBlockItemDataProperties;
import io.papermc.paper.datacomponent.item.PaperBundleContents;
import io.papermc.paper.datacomponent.item.PaperChargedProjectiles;
import io.papermc.paper.datacomponent.item.PaperConsumable;
import io.papermc.paper.datacomponent.item.PaperCustomModelData;
import io.papermc.paper.datacomponent.item.PaperDamageResistant;
import io.papermc.paper.datacomponent.item.PaperDeathProtection;
import io.papermc.paper.datacomponent.item.PaperDyedItemColor;
import io.papermc.paper.datacomponent.item.PaperEnchantable;
import io.papermc.paper.datacomponent.item.PaperEquippable;
import io.papermc.paper.datacomponent.item.PaperFireworks;
import io.papermc.paper.datacomponent.item.PaperFoodProperties;
import io.papermc.paper.datacomponent.item.PaperItemAdventurePredicate;
import io.papermc.paper.datacomponent.item.PaperItemArmorTrim;
import io.papermc.paper.datacomponent.item.PaperItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.PaperItemContainerContents;
import io.papermc.paper.datacomponent.item.PaperItemEnchantments;
import io.papermc.paper.datacomponent.item.PaperItemLore;
import io.papermc.paper.datacomponent.item.PaperItemTool;
import io.papermc.paper.datacomponent.item.PaperJukeboxPlayable;
import io.papermc.paper.datacomponent.item.PaperLodestoneTracker;
import io.papermc.paper.datacomponent.item.PaperMapDecorations;
import io.papermc.paper.datacomponent.item.PaperMapId;
import io.papermc.paper.datacomponent.item.PaperMapItemColor;
import io.papermc.paper.datacomponent.item.PaperOminousBottleAmplifier;
import io.papermc.paper.datacomponent.item.PaperPotDecorations;
import io.papermc.paper.datacomponent.item.PaperPotionContents;
import io.papermc.paper.datacomponent.item.PaperRepairable;
import io.papermc.paper.datacomponent.item.PaperResolvableProfile;
import io.papermc.paper.datacomponent.item.PaperSeededContainerLoot;
import io.papermc.paper.datacomponent.item.PaperSuspiciousStewEffects;
import io.papermc.paper.datacomponent.item.PaperUnbreakable;
import io.papermc.paper.datacomponent.item.PaperUseCooldown;
import io.papermc.paper.datacomponent.item.PaperUseRemainder;
import io.papermc.paper.datacomponent.item.PaperWritableBookContent;
import io.papermc.paper.datacomponent.item.PaperWrittenBookContent;
import io.papermc.paper.datacomponent.item.PotDecorations;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.datacomponent.item.Repairable;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.datacomponent.item.SeededContainerLoot;
import io.papermc.paper.datacomponent.item.SuspiciousStewEffects;
import io.papermc.paper.datacomponent.item.Tool;
import io.papermc.paper.datacomponent.item.Unbreakable;
import io.papermc.paper.datacomponent.item.UseCooldown;
import io.papermc.paper.datacomponent.item.UseRemainder;
import io.papermc.paper.datacomponent.item.WritableBookContent;
import io.papermc.paper.datacomponent.item.WrittenBookContent;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.text.Filtered;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.component.OminousBottleAmplifier;
import org.bukkit.JukeboxSong;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.damage.DamageType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.map.MapCursor;
import org.jspecify.annotations.Nullable;

public final class ItemComponentTypesBridgesImpl
implements ItemComponentTypesBridge {
    public ChargedProjectiles.Builder chargedProjectiles() {
        return new PaperChargedProjectiles.BuilderImpl();
    }

    public PotDecorations.Builder potDecorations() {
        return new PaperPotDecorations.BuilderImpl();
    }

    public Unbreakable.Builder unbreakable() {
        return new PaperUnbreakable.BuilderImpl();
    }

    public ItemLore.Builder lore() {
        return new PaperItemLore.BuilderImpl();
    }

    public ItemEnchantments.Builder enchantments() {
        return new PaperItemEnchantments.BuilderImpl();
    }

    public ItemAttributeModifiers.Builder modifiers() {
        return new PaperItemAttributeModifiers.BuilderImpl();
    }

    public FoodProperties.Builder food() {
        return new PaperFoodProperties.BuilderImpl();
    }

    public DyedItemColor.Builder dyedItemColor() {
        return new PaperDyedItemColor.BuilderImpl();
    }

    public PotionContents.Builder potionContents() {
        return new PaperPotionContents.BuilderImpl();
    }

    public BundleContents.Builder bundleContents() {
        return new PaperBundleContents.BuilderImpl();
    }

    public SuspiciousStewEffects.Builder suspiciousStewEffects() {
        return new PaperSuspiciousStewEffects.BuilderImpl();
    }

    public MapItemColor.Builder mapItemColor() {
        return new PaperMapItemColor.BuilderImpl();
    }

    public MapDecorations.Builder mapDecorations() {
        return new PaperMapDecorations.BuilderImpl();
    }

    public MapDecorations.DecorationEntry decorationEntry(MapCursor.Type type, double x2, double z2, float rotation) {
        return PaperMapDecorations.PaperDecorationEntry.toApi(type, x2, z2, rotation);
    }

    public SeededContainerLoot.Builder seededContainerLoot(Key lootTableKey) {
        return new PaperSeededContainerLoot.BuilderImpl(lootTableKey);
    }

    public ItemContainerContents.Builder itemContainerContents() {
        return new PaperItemContainerContents.BuilderImpl();
    }

    public JukeboxPlayable.Builder jukeboxPlayable(JukeboxSong song) {
        return new PaperJukeboxPlayable.BuilderImpl(song);
    }

    public Tool.Builder tool() {
        return new PaperItemTool.BuilderImpl();
    }

    public Tool.Rule rule(RegistryKeySet<BlockType> blocks, @Nullable Float speed, TriState correctForDrops) {
        return PaperItemTool.PaperRule.fromUnsafe(blocks, speed, correctForDrops);
    }

    public ItemAdventurePredicate.Builder itemAdventurePredicate() {
        return new PaperItemAdventurePredicate.BuilderImpl();
    }

    public WrittenBookContent.Builder writtenBookContent(Filtered<String> title, String author) {
        return new PaperWrittenBookContent.BuilderImpl(title, author);
    }

    public WritableBookContent.Builder writeableBookContent() {
        return new PaperWritableBookContent.BuilderImpl();
    }

    public ItemArmorTrim.Builder itemArmorTrim(ArmorTrim armorTrim) {
        return new PaperItemArmorTrim.BuilderImpl(armorTrim);
    }

    public LodestoneTracker.Builder lodestoneTracker() {
        return new PaperLodestoneTracker.BuilderImpl();
    }

    public Fireworks.Builder fireworks() {
        return new PaperFireworks.BuilderImpl();
    }

    public ResolvableProfile.Builder resolvableProfile() {
        return new PaperResolvableProfile.BuilderImpl();
    }

    public ResolvableProfile resolvableProfile(PlayerProfile profile) {
        return PaperResolvableProfile.toApi(profile);
    }

    public BannerPatternLayers.Builder bannerPatternLayers() {
        return new PaperBannerPatternLayers.BuilderImpl();
    }

    public BlockItemDataProperties.Builder blockItemStateProperties() {
        return new PaperBlockItemDataProperties.BuilderImpl();
    }

    public MapId mapId(int id) {
        return new PaperMapId(new net.minecraft.world.level.saveddata.maps.MapId(id));
    }

    public UseRemainder useRemainder(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Item cannot be null");
        Preconditions.checkArgument((!itemStack.isEmpty() ? 1 : 0) != 0, (Object)"Remaining item cannot be empty!");
        return new PaperUseRemainder(new net.minecraft.world.item.component.UseRemainder(CraftItemStack.asNMSCopy(itemStack)));
    }

    public Consumable.Builder consumable() {
        return new PaperConsumable.BuilderImpl();
    }

    public UseCooldown.Builder useCooldown(float seconds) {
        Preconditions.checkArgument((seconds > 0.0f ? 1 : 0) != 0, (String)"seconds must be positive, was %s", (Object)Float.valueOf(seconds));
        return new PaperUseCooldown.BuilderImpl(seconds);
    }

    public DamageResistant damageResistant(TagKey<DamageType> types) {
        return new PaperDamageResistant(new net.minecraft.world.item.component.DamageResistant(PaperRegistries.toNms(types)));
    }

    public Enchantable enchantable(int level) {
        return new PaperEnchantable(new net.minecraft.world.item.enchantment.Enchantable(level));
    }

    public Repairable repairable(RegistryKeySet<ItemType> types) {
        return new PaperRepairable(new net.minecraft.world.item.enchantment.Repairable(PaperRegistrySets.convertToNms(Registries.K, BuiltInRegistries.BUILT_IN_CONVERSIONS.lookup(), types)));
    }

    public Equippable.Builder equippable(EquipmentSlot slot) {
        return new PaperEquippable.BuilderImpl(slot);
    }

    public DeathProtection.Builder deathProtection() {
        return new PaperDeathProtection.BuilderImpl();
    }

    public CustomModelData.Builder customModelData() {
        return new PaperCustomModelData.BuilderImpl();
    }

    public PaperOminousBottleAmplifier ominousBottleAmplifier(int amplifier) {
        Preconditions.checkArgument((0 <= amplifier && amplifier <= 4 ? 1 : 0) != 0, (String)"amplifier must be between %s-%s, was %s", (Object)0, (Object)4, (Object)amplifier);
        return new PaperOminousBottleAmplifier(new OminousBottleAmplifier(amplifier));
    }
}

