/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type.number;

import com.google.common.base.Preconditions;
import io.papermc.paper.configuration.type.number.OptionalNumSerializer;
import java.util.OptionalDouble;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.configurate.serialize.ScalarSerializer;

public interface DoubleOr {
    default public double or(double fallback) {
        return this.value().orElse(fallback);
    }

    public OptionalDouble value();

    default public double doubleValue() {
        return this.value().orElseThrow();
    }

    public static final class Serializer<T extends DoubleOr>
    extends OptionalNumSerializer<T, OptionalDouble> {
        Serializer(Class<T> classOfT, Function<OptionalDouble, T> factory, String emptySerializedValue, T emptyValue) {
            super(classOfT, emptySerializedValue, emptyValue, OptionalDouble::empty, OptionalDouble::isEmpty, factory, Double.TYPE);
        }

        protected Object serialize(T item, Predicate<Class<?>> typeSupported) {
            OptionalDouble value = item.value();
            if (value.isPresent()) {
                return value.getAsDouble();
            }
            return this.emptySerializedValue;
        }

        @Override
        protected OptionalDouble full(String value) {
            return OptionalDouble.of(Double.parseDouble(value));
        }

        @Override
        protected OptionalDouble full(Number num) {
            return OptionalDouble.of(num.doubleValue());
        }

        @Override
        protected boolean belowZero(OptionalDouble value) {
            Preconditions.checkArgument((boolean)value.isPresent());
            return value.getAsDouble() < 0.0;
        }
    }

    public record Disabled(OptionalDouble value) implements DoubleOr
    {
        private static final String DISABLED_VALUE = "disabled";
        public static final Disabled DISABLED = new Disabled(OptionalDouble.empty());
        public static final ScalarSerializer<Disabled> SERIALIZER = new Serializer<Disabled>(Disabled.class, Disabled::new, "disabled", DISABLED);

        public boolean test(DoublePredicate predicate) {
            return this.value.isPresent() && predicate.test(this.value.getAsDouble());
        }

        public boolean enabled() {
            return this.value.isPresent();
        }
    }

    public record Default(OptionalDouble value) implements DoubleOr
    {
        private static final String DEFAULT_VALUE = "default";
        public static final Default USE_DEFAULT = new Default(OptionalDouble.empty());
        public static final ScalarSerializer<Default> SERIALIZER = new Serializer<Default>(Default.class, Default::new, "default", USE_DEFAULT);
    }
}

