/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type.fallback;

import io.leangen.geantyref.GenericTypeReflector;
import io.papermc.paper.configuration.type.fallback.ArrowDespawnRate;
import io.papermc.paper.configuration.type.fallback.AutosavePeriod;
import io.papermc.paper.configuration.type.fallback.FallbackValue;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public class FallbackValueSerializer
extends ScalarSerializer<FallbackValue> {
    private static final Map<Class<?>, FallbackCreator<?>> REGISTRY = new HashMap();
    private final Map<FallbackValue.ContextKey<?>, Object> contextMap;

    FallbackValueSerializer(Map<FallbackValue.ContextKey<?>, Object> contextMap) {
        super(FallbackValue.class);
        this.contextMap = contextMap;
    }

    public FallbackValue deserialize(Type type, Object obj) throws SerializationException {
        FallbackCreator<?> creator = REGISTRY.get(GenericTypeReflector.erase((Type)type));
        if (creator == null) {
            throw new SerializationException(String.valueOf(type) + " does not have a FallbackCreator registered");
        }
        return creator.create(this.contextMap, obj);
    }

    protected Object serialize(FallbackValue item, Predicate<Class<?>> typeSupported) {
        return item.serialize();
    }

    public static FallbackValueSerializer create(SpigotWorldConfig config, Supplier<MinecraftServer> server) {
        return new FallbackValueSerializer(Map.of(FallbackValue.SPIGOT_WORLD_CONFIG, config, FallbackValue.MINECRAFT_SERVER, server));
    }

    static {
        REGISTRY.put(ArrowDespawnRate.class, ArrowDespawnRate::new);
        REGISTRY.put(AutosavePeriod.class, AutosavePeriod::new);
    }

    @FunctionalInterface
    private static interface FallbackCreator<T extends FallbackValue> {
        public T create(Map<FallbackValue.ContextKey<?>, Object> var1, Object var2) throws SerializationException;
    }
}

