/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer.collections;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class TableSerializer
implements TypeSerializer<Table<?, ?, ?>> {
    private static final int ROW_TYPE_ARGUMENT_INDEX = 0;
    private static final int COLUMN_TYPE_ARGUMENT_INDEX = 1;
    private static final int VALUE_TYPE_ARGUMENT_INDEX = 2;

    public Table<?, ?, ?> deserialize(Type type, ConfigurationNode node) throws SerializationException {
        HashBasedTable table = HashBasedTable.create();
        if (!node.empty() && node.isMap()) {
            this.deserialize0((Table)table, (ParameterizedType)type, node);
        }
        return table;
    }

    private <R, C, V> void deserialize0(Table<R, C, V> table, ParameterizedType type, ConfigurationNode node) throws SerializationException {
        Type rowType = type.getActualTypeArguments()[0];
        Type columnType = type.getActualTypeArguments()[1];
        Type valueType = type.getActualTypeArguments()[2];
        TypeSerializer rowKeySerializer = node.options().serializers().get(rowType);
        if (rowKeySerializer == null) {
            throw new SerializationException("Could not find serializer for table row type " + String.valueOf(rowType));
        }
        Type mapType = TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{columnType, valueType});
        TypeSerializer columnValueSerializer = node.options().serializers().get(mapType);
        if (columnValueSerializer == null) {
            throw new SerializationException("Could not find serializer for table column-value map " + String.valueOf(type));
        }
        BasicConfigurationNode rowKeyNode = BasicConfigurationNode.root((ConfigurationOptions)node.options());
        for (Object key : node.childrenMap().keySet()) {
            Object rowKey = rowKeySerializer.deserialize(rowType, (ConfigurationNode)rowKeyNode.set(key));
            Map map = (Map)columnValueSerializer.deserialize(mapType, node.node(new Object[]{rowKeyNode.raw()}));
            map.forEach((column, value) -> table.put(rowKey, column, value));
        }
    }

    public void serialize(Type type, @Nullable Table<?, ?, ?> table, ConfigurationNode node) throws SerializationException {
        if (table != null) {
            this.serialize0(table, (ParameterizedType)type, node);
        }
    }

    private <R, C, V> void serialize0(Table<R, C, V> table, ParameterizedType type, ConfigurationNode node) throws SerializationException {
        Type rowType = type.getActualTypeArguments()[0];
        Type columnType = type.getActualTypeArguments()[1];
        Type valueType = type.getActualTypeArguments()[2];
        TypeSerializer rowKeySerializer = node.options().serializers().get(rowType);
        if (rowKeySerializer == null) {
            throw new SerializationException("Could not find a serializer for table row type " + String.valueOf(rowType));
        }
        BasicConfigurationNode rowKeyNode = BasicConfigurationNode.root((ConfigurationOptions)node.options());
        for (Object key : table.rowKeySet()) {
            rowKeySerializer.serialize(rowType, key, (ConfigurationNode)rowKeyNode.set(key));
            Object keyObj = Objects.requireNonNull(rowKeyNode.raw());
            node.node(new Object[]{keyObj}).set(TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{columnType, valueType}), (Object)table.row(key));
        }
    }

    public @Nullable Table<?, ?, ?> emptyValue(Type specificType, ConfigurationOptions options) {
        return ImmutableTable.of();
    }
}

