/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import io.papermc.paper.command.PaperSubcommand;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class HeapDumpCommand
implements PaperSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        this.dumpHeap(sender);
        return true;
    }

    private void dumpHeap(CommandSender sender) {
        Path dir = Paths.get("./dumps", new String[0]);
        String name = "heap-dump-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now());
        Command.broadcastCommandMessage((CommandSender)sender, (Component)Component.text((String)"Writing JVM heap data...", (TextColor)NamedTextColor.YELLOW));
        Path file = CraftServer.dumpHeap(dir, name);
        if (file != null) {
            Command.broadcastCommandMessage((CommandSender)sender, (Component)Component.text((String)("Heap dump saved to " + String.valueOf(file)), (TextColor)NamedTextColor.GREEN));
        } else {
            Command.broadcastCommandMessage((CommandSender)sender, (Component)Component.text((String)"Failed to write heap dump, see server log for details", (TextColor)NamedTextColor.RED));
        }
    }
}

