/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.brigadier.argument;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.command.brigadier.argument.SignedMessageResolver;
import io.papermc.paper.command.brigadier.argument.SignedMessageResolverImpl;
import io.papermc.paper.command.brigadier.argument.VanillaArgumentProvider;
import io.papermc.paper.command.brigadier.argument.predicate.ItemStackPredicate;
import io.papermc.paper.command.brigadier.argument.range.DoubleRangeProvider;
import io.papermc.paper.command.brigadier.argument.range.IntegerRangeProvider;
import io.papermc.paper.command.brigadier.argument.range.RangeProvider;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.PlayerProfileListResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.math.Rotation;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.util.MCUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.StyleArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.GameMode;
import org.bukkit.HeightMap;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_21_R3.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_21_R3.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class VanillaArgumentProviderImpl
implements VanillaArgumentProvider {
    public ArgumentType<EntitySelectorArgumentResolver> entity() {
        return this.wrap(ArgumentEntity.a(), result -> sourceStack -> List.of(result.a((CommandListenerWrapper)sourceStack).getBukkitEntity()));
    }

    public ArgumentType<EntitySelectorArgumentResolver> entities() {
        return this.wrap(ArgumentEntity.b(), result -> sourceStack -> Lists.transform(result.b((CommandListenerWrapper)sourceStack), Entity::getBukkitEntity));
    }

    public ArgumentType<PlayerSelectorArgumentResolver> player() {
        return this.wrap(ArgumentEntity.c(), result -> sourceStack -> List.of(result.c((CommandListenerWrapper)sourceStack).getBukkitEntity()));
    }

    public ArgumentType<PlayerSelectorArgumentResolver> players() {
        return this.wrap(ArgumentEntity.d(), result -> sourceStack -> Lists.transform(result.d((CommandListenerWrapper)sourceStack), EntityPlayer::getBukkitEntity));
    }

    public ArgumentType<PlayerProfileListResolver> playerProfiles() {
        return this.wrap(ArgumentProfile.a(), result -> {
            if (result instanceof ArgumentProfile.b) {
                return sourceStack -> Collections.unmodifiableCollection(Collections2.transform(result.getNames((CommandListenerWrapper)sourceStack), CraftPlayerProfile::new));
            }
            return sourceStack -> Collections.unmodifiableCollection(Collections2.transform(result.getNames((CommandListenerWrapper)sourceStack), CraftPlayerProfile::new));
        });
    }

    public ArgumentType<BlockPositionResolver> blockPosition() {
        return this.wrap(ArgumentPosition.a(), result -> sourceStack -> {
            BlockPosition pos = result.c((CommandListenerWrapper)sourceStack);
            return MCUtil.toPosition(pos);
        });
    }

    public ArgumentType<FinePositionResolver> finePosition(boolean centerIntegers) {
        return this.wrap(ArgumentVec3.a(centerIntegers), result -> sourceStack -> {
            Vec3D vec3 = result.a((CommandListenerWrapper)sourceStack);
            return MCUtil.toPosition(vec3);
        });
    }

    public ArgumentType<RotationResolver> rotation() {
        return this.wrap(ArgumentRotation.a(), result -> sourceStack -> {
            Vec2F vec2 = result.b((CommandListenerWrapper)sourceStack);
            return Rotation.rotation((float)vec2.j, (float)vec2.i);
        });
    }

    public ArgumentType<BlockState> blockState() {
        return this.wrap(ArgumentTile.a(PaperCommands.INSTANCE.getBuildContext()), result -> CraftBlockStates.getBlockState(CraftRegistry.getMinecraftRegistry(), BlockPosition.c, result.a(), result.c));
    }

    public ArgumentType<ItemStack> itemStack() {
        return this.wrap(ArgumentItemStack.a(PaperCommands.INSTANCE.getBuildContext()), result -> CraftItemStack.asBukkitCopy(result.a(1, true)));
    }

    public ArgumentType<ItemStackPredicate> itemStackPredicate() {
        return this.wrap(ArgumentItemPredicate.a(PaperCommands.INSTANCE.getBuildContext()), type -> itemStack -> type.test(CraftItemStack.asNMSCopy(itemStack)));
    }

    public ArgumentType<NamedTextColor> namedColor() {
        return this.wrap(ArgumentChatFormat.a(), result -> Objects.requireNonNull(NamedTextColor.namedColor((int)Objects.requireNonNull(result.f(), () -> String.valueOf(result) + " didn't have a color")), () -> result.f() + " didn't map to an adventure named color"));
    }

    public ArgumentType<Component> component() {
        return this.wrap(ArgumentChatComponent.a(PaperCommands.INSTANCE.getBuildContext()), PaperAdventure::asAdventure);
    }

    public ArgumentType<Style> style() {
        return this.wrap(StyleArgument.a(PaperCommands.INSTANCE.getBuildContext()), PaperAdventure::asAdventure);
    }

    public ArgumentType<SignedMessageResolver> signedMessage() {
        return this.wrap(ArgumentChat.a(), SignedMessageResolverImpl::new);
    }

    public ArgumentType<DisplaySlot> scoreboardDisplaySlot() {
        return this.wrap(ArgumentScoreboardSlot.a(), CraftScoreboardTranslations::toBukkitSlot);
    }

    public ArgumentType<NamespacedKey> namespacedKey() {
        return this.wrap(ArgumentMinecraftKeyRegistered.a(), CraftNamespacedKey::fromMinecraft);
    }

    public ArgumentType<Key> key() {
        return this.wrap(ArgumentMinecraftKeyRegistered.a(), CraftNamespacedKey::fromMinecraft);
    }

    public ArgumentType<IntegerRangeProvider> integerRange() {
        return this.wrap(ArgumentCriterionValue.a(), type -> VanillaArgumentProviderImpl.convertToRange(type, integerRange -> () -> integerRange));
    }

    public ArgumentType<DoubleRangeProvider> doubleRange() {
        return this.wrap(ArgumentCriterionValue.b(), type -> VanillaArgumentProviderImpl.convertToRange(type, doubleRange -> () -> doubleRange));
    }

    private static <C extends Number, T extends RangeProvider<C>> T convertToRange(CriterionConditionValue<C> bounds, Function<Range<C>, T> converter) {
        if (bounds.c()) {
            return (T)((RangeProvider)converter.apply(Range.all()));
        }
        if (bounds.a().isPresent() && bounds.b().isPresent()) {
            return (T)((RangeProvider)converter.apply(Range.closed((Comparable)((Object)((Number)bounds.a().get())), (Comparable)((Object)((Number)bounds.b().get())))));
        }
        if (bounds.b().isPresent()) {
            return (T)((RangeProvider)converter.apply(Range.atMost((Comparable)((Object)((Number)bounds.b().get())))));
        }
        if (bounds.a().isPresent()) {
            return (T)((RangeProvider)converter.apply(Range.atLeast((Comparable)((Object)((Number)bounds.a().get())))));
        }
        throw new IllegalStateException("This is a bug: " + String.valueOf(bounds));
    }

    public ArgumentType<World> world() {
        return this.wrap(ArgumentDimension.a(), dimensionLocation -> {
            ResourceKey<net.minecraft.world.level.World> resourceKey = ResourceKey.a(Registries.be, dimensionLocation);
            @Nullable WorldServer serverLevel = MinecraftServer.getServer().a(resourceKey);
            if (serverLevel == null) {
                throw ArgumentDimension.b.create(dimensionLocation);
            }
            return serverLevel.getWorld();
        });
    }

    public ArgumentType<GameMode> gameMode() {
        return this.wrap(GameModeArgument.a(), type -> Objects.requireNonNull(GameMode.getByValue((int)type.a())));
    }

    public ArgumentType<HeightMap> heightMap() {
        return this.wrap(HeightmapTypeArgument.a(), CraftHeightMap::fromNMS);
    }

    public ArgumentType<UUID> uuid() {
        return this.wrap(ArgumentUUID.a());
    }

    public ArgumentType<Criteria> objectiveCriteria() {
        return this.wrap(ArgumentScoreboardCriteria.a(), CraftCriteria::getFromNMS);
    }

    public ArgumentType<LookAnchor> entityAnchor() {
        return this.wrap(ArgumentAnchor.a(), type -> LookAnchor.valueOf((String)type.name()));
    }

    public ArgumentType<Integer> time(int minTicks) {
        return this.wrap(ArgumentTime.a(minTicks));
    }

    public ArgumentType<Mirror> templateMirror() {
        return this.wrap(TemplateMirrorArgument.a(), mirror -> Mirror.valueOf((String)mirror.name()));
    }

    public ArgumentType<StructureRotation> templateRotation() {
        return this.wrap(TemplateRotationArgument.a(), mirror -> StructureRotation.valueOf((String)mirror.name()));
    }

    public <T> ArgumentType<TypedKey<T>> resourceKey(RegistryKey<T> registryKey) {
        return this.wrap(ResourceKeyArgument.a(PaperRegistries.registryToNms(registryKey)), nmsRegistryKey -> TypedKey.create((RegistryKey)registryKey, (Key)CraftNamespacedKey.fromMinecraft(nmsRegistryKey.a())));
    }

    public <T> ArgumentType<T> resource(RegistryKey<T> registryKey) {
        return this.resourceRaw(registryKey);
    }

    private <T, K extends Keyed> ArgumentType<T> resourceRaw(RegistryKey registryKeyRaw) {
        RegistryKey registryKey = registryKeyRaw;
        return this.wrap(ResourceArgument.a(PaperCommands.INSTANCE.getBuildContext(), PaperRegistries.registryToNms(registryKey)), resource -> Objects.requireNonNull(RegistryAccess.registryAccess().getRegistry(registryKey).get(CraftNamespacedKey.fromMinecraft(resource.h().a()))));
    }

    private <T> ArgumentType<T> wrap(ArgumentType<T> base) {
        return this.wrap(base, identity -> identity);
    }

    private <B, C> ArgumentType<C> wrap(ArgumentType<B> base, ResultConverter<B, C> converter) {
        return new NativeWrapperArgumentType<B, C>(base, converter);
    }

    @FunctionalInterface
    static interface ResultConverter<T, R> {
        public R convert(T var1) throws CommandSyntaxException;
    }

    public static final class NativeWrapperArgumentType<M, P>
    implements ArgumentType<P> {
        private final ArgumentType<M> nmsBase;
        private final ResultConverter<M, P> converter;

        private NativeWrapperArgumentType(ArgumentType<M> nmsBase, ResultConverter<M, P> converter) {
            this.nmsBase = nmsBase;
            this.converter = converter;
        }

        public ArgumentType<M> nativeNmsArgumentType() {
            return this.nmsBase;
        }

        public P parse(StringReader reader) throws CommandSyntaxException {
            return this.converter.convert(this.nmsBase.parse(reader));
        }

        public <S> P parse(StringReader reader, S source) throws CommandSyntaxException {
            return this.converter.convert(this.nmsBase.parse(reader, source));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return this.nmsBase.listSuggestions(context, builder);
        }

        public Collection<String> getExamples() {
            return this.nmsBase.getExamples();
        }
    }
}

