/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.AsyncChatCommandDecorateEvent;
import io.papermc.paper.event.player.AsyncChatDecorateEvent;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class ImprovedChatDecorator
implements ChatDecorator {
    private final MinecraftServer server;

    public ImprovedChatDecorator(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public CompletableFuture<IChatBaseComponent> decorate(@Nullable EntityPlayer sender, IChatBaseComponent message) {
        return ImprovedChatDecorator.decorate(this.server, sender, null, message);
    }

    @Override
    public CompletableFuture<IChatBaseComponent> decorate(@Nullable EntityPlayer sender, @Nullable CommandListenerWrapper commandSourceStack, IChatBaseComponent message) {
        return ImprovedChatDecorator.decorate(this.server, sender, commandSourceStack, message);
    }

    private static CompletableFuture<IChatBaseComponent> decorate(MinecraftServer server, @Nullable EntityPlayer player, @Nullable CommandListenerWrapper commandSourceStack, IChatBaseComponent originalMessage) {
        return CompletableFuture.supplyAsync(() -> {
            Component initialResult = PaperAdventure.asAdventure(originalMessage);
            @Nullable CraftPlayer craftPlayer = player == null ? null : player.getBukkitEntity();
            Object event = commandSourceStack != null ? new AsyncChatCommandDecorateEvent((Player)craftPlayer, initialResult) : new AsyncChatDecorateEvent((Player)craftPlayer, initialResult);
            if (event.callEvent()) {
                return PaperAdventure.asVanilla(event.result());
            }
            return originalMessage;
        }, server.chatExecutor);
    }
}

