/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.network;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.network.PaperServerListPingEventImpl;
import com.destroystokyo.paper.network.PaperStatusClient;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.adventure.AdventureComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.status.PacketStatusOutServerInfo;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftIconCache;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public final class StandardPaperServerListPingEventImpl
extends PaperServerListPingEventImpl {
    private List<GameProfile> originalSample;

    private StandardPaperServerListPingEventImpl(MinecraftServer server, NetworkManager networkManager, ServerPing ping) {
        super(server, new PaperStatusClient(networkManager), ping.c().map(ServerPing.ServerData::c).orElse(-1), server.server.getServerIcon());
        this.originalSample = ping.b().map(ServerPing.ServerPingPlayerSample::c).orElse(null);
    }

    @Nonnull
    public List<PaperServerListPingEvent.ListedPlayerInfo> getListedPlayers() {
        List sample = super.getListedPlayers();
        if (this.originalSample != null) {
            for (GameProfile profile : this.originalSample) {
                sample.add(new PaperServerListPingEvent.ListedPlayerInfo(profile.getName(), profile.getId()));
            }
            this.originalSample = null;
        }
        return sample;
    }

    @NotNull
    public List<PlayerProfile> getPlayerSample() {
        this.getListedPlayers();
        return super.getPlayerSample();
    }

    private List<GameProfile> getPlayerSampleHandle() {
        if (this.originalSample != null) {
            return this.originalSample;
        }
        List entries = super.getListedPlayers();
        if (entries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GameProfile> profiles = new ArrayList<GameProfile>();
        for (PaperServerListPingEvent.ListedPlayerInfo playerInfo : entries) {
            profiles.add(new GameProfile(playerInfo.id(), playerInfo.name()));
        }
        return profiles;
    }

    public static void processRequest(MinecraftServer server, NetworkManager networkManager) {
        StandardPaperServerListPingEventImpl event = new StandardPaperServerListPingEventImpl(server, networkManager, server.au());
        server.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            networkManager.a((IChatBaseComponent)null);
            return;
        }
        AdventureComponent description = new AdventureComponent(event.motd());
        Optional<ServerPing.ServerPingPlayerSample> players = !event.shouldHidePlayers() ? Optional.of(new ServerPing.ServerPingPlayerSample(event.getMaxPlayers(), event.getNumPlayers(), event.getPlayerSampleHandle())) : Optional.empty();
        ServerPing.ServerData version = new ServerPing.ServerData(event.getVersion(), event.getProtocolVersion());
        Optional<ServerPing.a> favicon = event.getServerIcon() != null ? Optional.of(new ServerPing.a(((CraftIconCache)event.getServerIcon()).value)) : Optional.empty();
        ServerPing ping = new ServerPing(description, players, Optional.of(version), favicon, server.aA());
        networkManager.a(new PacketStatusOutServerInfo(ping));
    }
}

