/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.loottable;

import com.destroystokyo.paper.loottable.LootableInventory;
import com.destroystokyo.paper.loottable.LootableInventoryReplenishEvent;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DurationOrDisabled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperLootableInventoryData {
    private static final Random RANDOM = new Random();
    private long lastFill = -1L;
    private long nextRefill = -1L;
    private int numRefills = 0;
    private @Nullable Map<UUID, Long> lootedPlayers;
    public static final LootTableInterface<RandomizableContainer> CONTAINER = new LootTableInterface<RandomizableContainer>(){

        @Override
        public WorldConfiguration paperConfig(RandomizableContainer holder) {
            return Objects.requireNonNull(holder.i(), "Can only manager loot replenishment on block entities in a world").paperConfig();
        }

        @Override
        public void setSeed(RandomizableContainer holder, long seed) {
            holder.a(seed);
        }

        @Override
        public boolean hasLootTable(RandomizableContainer holder) {
            return holder.aw_() != null;
        }

        @Override
        public LootableInventory getInventoryForEvent(RandomizableContainer holder) {
            return holder.getLootableInventory();
        }
    };
    public static final LootTableInterface<ContainerEntity> ENTITY = new LootTableInterface<ContainerEntity>(){

        @Override
        public WorldConfiguration paperConfig(ContainerEntity holder) {
            return holder.dV().paperConfig();
        }

        @Override
        public void setSeed(ContainerEntity holder, long seed) {
            holder.a(seed);
        }

        @Override
        public boolean hasLootTable(ContainerEntity holder) {
            return holder.v() != null;
        }

        @Override
        public LootableInventory getInventoryForEvent(ContainerEntity holder) {
            return holder.getLootableInventory();
        }
    };
    private static final String ROOT = "Paper.LootableData";
    private static final String LAST_FILL = "lastFill";
    private static final String NEXT_REFILL = "nextRefill";
    private static final String NUM_REFILLS = "numRefills";
    private static final String LOOTED_PLAYERS = "lootedPlayers";

    public long getLastFill() {
        return this.lastFill;
    }

    long getNextRefill() {
        return this.nextRefill;
    }

    long setNextRefill(long nextRefill) {
        long prev = this.nextRefill;
        this.nextRefill = nextRefill;
        return prev;
    }

    public <T> boolean shouldReplenish(T lootTableHolder, LootTableInterface<T> holderInterface, @Nullable EntityHuman player) {
        if (!holderInterface.hasLootTable(lootTableHolder)) {
            return false;
        }
        if (this.lastFill == -1L || !holderInterface.paperConfig(lootTableHolder).lootables.autoReplenish) {
            return true;
        }
        if (player == null) {
            return false;
        }
        if (this.nextRefill == -1L) {
            return false;
        }
        WorldConfiguration paperConfig = holderInterface.paperConfig(lootTableHolder);
        if (paperConfig.lootables.maxRefills != -1 && this.numRefills >= paperConfig.lootables.maxRefills) {
            return false;
        }
        if (this.nextRefill > System.currentTimeMillis()) {
            return false;
        }
        Player bukkitPlayer = (Player)player.getBukkitEntity();
        LootableInventoryReplenishEvent event = new LootableInventoryReplenishEvent(bukkitPlayer, holderInterface.getInventoryForEvent(lootTableHolder));
        event.setCancelled(!this.canPlayerLoot(player.cG(), paperConfig));
        return event.callEvent();
    }

    public <T> boolean shouldClearLootTable(T lootTableHolder, LootTableInterface<T> holderInterface, @Nullable EntityHuman player) {
        this.lastFill = System.currentTimeMillis();
        WorldConfiguration paperConfig = holderInterface.paperConfig(lootTableHolder);
        if (paperConfig.lootables.autoReplenish) {
            long min = paperConfig.lootables.refreshMin.seconds();
            long max = paperConfig.lootables.refreshMax.seconds();
            this.nextRefill = this.lastFill + (min + RANDOM.nextLong(max - min + 1L)) * 1000L;
            ++this.numRefills;
            if (paperConfig.lootables.resetSeedOnFill) {
                holderInterface.setSeed(lootTableHolder, 0L);
            }
            if (player != null) {
                this.setPlayerLootedState(player.cG(), true);
            }
            return false;
        }
        return true;
    }

    public void loadNbt(NBTTagCompound base) {
        if (!base.b(ROOT, 10)) {
            return;
        }
        NBTTagCompound comp = base.p(ROOT);
        if (comp.e(LAST_FILL)) {
            this.lastFill = comp.i(LAST_FILL);
        }
        if (comp.e(NEXT_REFILL)) {
            this.nextRefill = comp.i(NEXT_REFILL);
        }
        if (comp.e(NUM_REFILLS)) {
            this.numRefills = comp.h(NUM_REFILLS);
        }
        if (comp.b(LOOTED_PLAYERS, 9)) {
            NBTTagList list = comp.c(LOOTED_PLAYERS, 10);
            int size = list.size();
            if (size > 0) {
                this.lootedPlayers = new HashMap<UUID, Long>(list.size());
            }
            for (int i2 = 0; i2 < size; ++i2) {
                NBTTagCompound cmp = list.a(i2);
                this.lootedPlayers.put(cmp.a("UUID"), cmp.i("Time"));
            }
        }
    }

    public void saveNbt(NBTTagCompound base) {
        NBTTagCompound comp = new NBTTagCompound();
        if (this.nextRefill != -1L) {
            comp.a(NEXT_REFILL, this.nextRefill);
        }
        if (this.lastFill != -1L) {
            comp.a(LAST_FILL, this.lastFill);
        }
        if (this.numRefills != 0) {
            comp.a(NUM_REFILLS, this.numRefills);
        }
        if (this.lootedPlayers != null && !this.lootedPlayers.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<UUID, Long> entry : this.lootedPlayers.entrySet()) {
                NBTTagCompound cmp = new NBTTagCompound();
                cmp.a("UUID", entry.getKey());
                cmp.a("Time", entry.getValue());
                list.add(cmp);
            }
            comp.a(LOOTED_PLAYERS, list);
        }
        if (!comp.g()) {
            base.a(ROOT, comp);
        }
    }

    void setPlayerLootedState(UUID player, boolean looted) {
        if (looted && this.lootedPlayers == null) {
            this.lootedPlayers = new HashMap<UUID, Long>();
        }
        if (looted) {
            this.lootedPlayers.put(player, System.currentTimeMillis());
        } else if (this.lootedPlayers != null) {
            this.lootedPlayers.remove(player);
        }
    }

    boolean canPlayerLoot(UUID player, WorldConfiguration worldConfiguration) {
        @Nullable Long lastLooted = this.getLastLooted(player);
        if (!worldConfiguration.lootables.restrictPlayerReloot || lastLooted == null) {
            return true;
        }
        DurationOrDisabled restrictPlayerRelootTime = worldConfiguration.lootables.restrictPlayerRelootTime;
        if (restrictPlayerRelootTime.value().isEmpty()) {
            return false;
        }
        return TimeUnit.SECONDS.toMillis(restrictPlayerRelootTime.value().get().seconds()) + lastLooted < System.currentTimeMillis();
    }

    boolean hasPlayerLooted(UUID player) {
        return this.lootedPlayers != null && this.lootedPlayers.containsKey(player);
    }

    @Nullable Long getLastLooted(UUID player) {
        return this.lootedPlayers != null ? this.lootedPlayers.get(player) : null;
    }

    public static interface LootTableInterface<T> {
        public WorldConfiguration paperConfig(T var1);

        public void setSeed(T var1, long var2);

        public boolean hasLootTable(T var1);

        public LootableInventory getInventoryForEvent(T var1);
    }
}

