/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity;

import com.destroystokyo.paper.entity.Pathfinder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;

public class PaperPathfinder
implements Pathfinder {
    private EntityInsentient entity;

    public PaperPathfinder(EntityInsentient entity) {
        this.entity = entity;
    }

    public Mob getEntity() {
        return (Mob)this.entity.getBukkitEntity();
    }

    public void setHandle(EntityInsentient entity) {
        this.entity = entity;
    }

    public void stopPathfinding() {
        this.entity.P().m();
    }

    public boolean hasPath() {
        return this.entity.P().i() != null && !this.entity.P().i().c();
    }

    @Nullable
    public Pathfinder.PathResult getCurrentPath() {
        PathEntity path = this.entity.P().i();
        return path != null && !path.c() ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(Location loc) {
        Validate.notNull((Object)loc, (String)"Location can not be null");
        PathEntity path = this.entity.P().a(loc.getX(), loc.getY(), loc.getZ(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(LivingEntity target) {
        Validate.notNull((Object)target, (String)"Target can not be null");
        PathEntity path = this.entity.P().a((Entity)((CraftLivingEntity)target).getHandle(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    public boolean moveTo(@Nonnull Pathfinder.PathResult path, double speed) {
        Validate.notNull((Object)path, (String)"PathResult can not be null");
        PathEntity pathEntity = ((PaperPathResult)path).path;
        return this.entity.P().a(pathEntity, speed);
    }

    public boolean canOpenDoors() {
        return this.entity.P().v.d.e();
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.entity.P().v.d.b(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.entity.P().v.d.d();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.entity.P().v.d.a(canPassDoors);
    }

    public boolean canFloat() {
        return this.entity.P().v.d.f();
    }

    public void setCanFloat(boolean canFloat) {
        this.entity.P().v.d.c(canFloat);
    }

    private Location toLoc(PathPoint point) {
        return new Location((World)this.entity.dV().getWorld(), (double)point.a, (double)point.b, (double)point.c);
    }

    public class PaperPathResult
    implements Pathfinder.PathResult {
        private final PathEntity path;

        PaperPathResult(PathEntity path) {
            this.path = path;
        }

        @Nullable
        public Location getFinalPoint() {
            PathPoint point = this.path.d();
            return point != null ? PaperPathfinder.this.toLoc(point) : null;
        }

        public boolean canReachFinalPoint() {
            return this.path.j();
        }

        public List<Location> getPoints() {
            ArrayList<Location> points = new ArrayList<Location>();
            for (PathPoint point : this.path.a) {
                points.add(PaperPathfinder.this.toLoc(point));
            }
            return points;
        }

        public int getNextPointIndex() {
            return this.path.f();
        }

        @Nullable
        public Location getNextPoint() {
            if (this.path.c()) {
                return null;
            }
            return PaperPathfinder.this.toLoc(this.path.a.get(this.path.f()));
        }
    }
}

