/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.starlight.light;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public final class SkyStarLightEngine
extends StarLightEngine {
    protected final int[] heightMapBlockChange = new int[256];
    protected final boolean[] nullPropagationCheckCache;
    protected final int[] heightMapGen;

    public SkyStarLightEngine(World world) {
        super(true, world);
        Arrays.fill(this.heightMapBlockChange, Integer.MIN_VALUE);
        this.heightMapGen = new int[1024];
        this.nullPropagationCheckCache = new boolean[WorldUtil.getTotalLightSections(world)];
    }

    @Override
    protected void initNibble(int chunkX, int chunkY, int chunkZ, boolean extrude, boolean initRemovedNibbles) {
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.getChunkInCache(chunkX, chunkZ) == null) {
            return;
        }
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble == null) {
            if (!initRemovedNibbles) {
                throw new IllegalStateException();
            }
            nibble = new SWMRNibbleArray(null, true);
            this.setNibbleInCache(chunkX, chunkY, chunkZ, nibble);
        }
        this.initNibble(nibble, chunkX, chunkY, chunkZ, extrude);
    }

    @Override
    protected void setNibbleNull(int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            nibble.setNull();
        }
    }

    protected final void initNibble(SWMRNibbleArray currNibble, int chunkX, int chunkY, int chunkZ, boolean extrude) {
        int currY;
        if (!currNibble.isNullNibbleUpdating()) {
            return;
        }
        boolean[] emptinessMap = this.getEmptinessMap(chunkX, chunkZ);
        int lowestY = this.minLightSection - 1;
        for (currY = this.maxSection; currY >= this.minSection; --currY) {
            ChunkSection current;
            if (emptinessMap == null ? (current = this.getChunkSection(chunkX, currY, chunkZ)) == null || current.c() : emptinessMap[currY - this.minSection]) continue;
            lowestY = currY;
            break;
        }
        if (chunkY > lowestY) {
            SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
            nibble.setNonNull();
            nibble.setFull();
            return;
        }
        if (extrude) {
            for (currY = chunkY + 1; currY <= this.maxLightSection; ++currY) {
                SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, currY, chunkZ);
                if (nibble == null || nibble.isNullNibbleUpdating()) continue;
                currNibble.setNonNull();
                currNibble.extrudeLower(nibble);
                break;
            }
        } else {
            currNibble.setNonNull();
        }
    }

    protected final void rewriteNibbleCacheForSkylight(IChunkAccess chunk) {
        for (SWMRNibbleArray nibble : this.nibbleCache) {
            if (nibble == null || !nibble.isNullNibbleUpdating()) continue;
            this.nibbleCache[index] = null;
            nibble.updateVisible();
        }
    }

    protected final boolean checkNullSection(int chunkX, int chunkY, int chunkZ, boolean extrudeInitialised) {
        int dx;
        int dz;
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.nullPropagationCheckCache[chunkY - this.minLightSection]) {
            return false;
        }
        this.nullPropagationCheckCache[chunkY - this.minLightSection] = true;
        boolean needInitNeighbours = false;
        block0: for (dz = -1; dz <= 1; ++dz) {
            for (dx = -1; dx <= 1; ++dx) {
                SWMRNibbleArray nibble = this.getNibbleFromCache(dx + chunkX, chunkY, dz + chunkZ);
                if (nibble == null || nibble.isNullNibbleUpdating()) continue;
                needInitNeighbours = true;
                break block0;
            }
        }
        if (needInitNeighbours) {
            for (dz = -1; dz <= 1; ++dz) {
                for (dx = -1; dx <= 1; ++dx) {
                    this.initNibble(dx + chunkX, chunkY, dz + chunkZ, (dx | dz) == 0 ? extrudeInitialised : true, true);
                }
            }
        }
        return needInitNeighbours;
    }

    protected final int getLightLevelExtruded(int worldX, int worldY, int worldZ) {
        int chunkX = worldX >> 4;
        int chunkY = worldY >> 4;
        int chunkZ = worldZ >> 4;
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            return nibble.getUpdating(worldX, worldY, worldZ);
        }
        do {
            if (++chunkY <= this.maxLightSection) continue;
            return 15;
        } while ((nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ)) == null);
        return nibble.getUpdating(worldX, 0, worldZ);
    }

    @Override
    protected boolean[] getEmptinessMap(IChunkAccess chunk) {
        return chunk.starlight$getSkyEmptinessMap();
    }

    @Override
    protected void setEmptinessMap(IChunkAccess chunk, boolean[] to) {
        chunk.starlight$setSkyEmptinessMap(to);
    }

    @Override
    protected SWMRNibbleArray[] getNibblesOnChunk(IChunkAccess chunk) {
        return chunk.starlight$getSkyNibbles();
    }

    @Override
    protected void setNibbles(IChunkAccess chunk, SWMRNibbleArray[] to) {
        chunk.starlight$setSkyNibbles(to);
    }

    @Override
    protected boolean canUseChunk(IChunkAccess chunk) {
        return chunk.n().a(ChunkStatus.l) && (this.isClientSide || chunk.x());
    }

    @Override
    protected void checkChunkEdges(ILightAccess lightAccess, IChunkAccess chunk, int fromSection, int toSection) {
        Arrays.fill(this.nullPropagationCheckCache, false);
        this.rewriteNibbleCacheForSkylight(chunk);
        int chunkX = chunk.f().h;
        int chunkZ = chunk.f().i;
        for (int y2 = toSection; y2 >= fromSection; --y2) {
            this.checkNullSection(chunkX, y2, chunkZ, true);
        }
        super.checkChunkEdges(lightAccess, chunk, fromSection, toSection);
    }

    @Override
    protected void checkChunkEdges(ILightAccess lightAccess, IChunkAccess chunk, ShortCollection sections) {
        Arrays.fill(this.nullPropagationCheckCache, false);
        this.rewriteNibbleCacheForSkylight(chunk);
        int chunkX = chunk.f().h;
        int chunkZ = chunk.f().i;
        ShortIterator iterator = sections.iterator();
        while (iterator.hasNext()) {
            short y2 = iterator.nextShort();
            this.checkNullSection(chunkX, y2, chunkZ, true);
        }
        super.checkChunkEdges(lightAccess, chunk, sections);
    }

    @Override
    protected void checkBlock(ILightAccess lightAccess, int worldX, int worldY, int worldZ) {
        int encodeOffset = this.coordinateOffset;
        int currentLevel = this.getLightLevel(worldX, worldY, worldZ);
        if (currentLevel == 15) {
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L | Long.MIN_VALUE);
        } else {
            this.setLightLevel(worldX, worldY, worldZ, 0);
        }
        this.appendToDecreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L);
    }

    @Override
    protected int calculateLightValue(ILightAccess lightAccess, int worldX, int worldY, int worldZ, int expect) {
        if (expect == 15) {
            return expect;
        }
        int sectionOffset = this.chunkSectionIndexOffset;
        IBlockData centerState = this.getBlockState(worldX, worldY, worldZ);
        int opacity = Math.max(1, centerState.g());
        IBlockData conditionallyOpaqueState = centerState.starlight$isConditionallyFullOpaque() ? centerState : null;
        int level = 0;
        for (StarLightEngine.AxisDirection direction : StarLightEngine.AXIS_DIRECTIONS) {
            int calculated;
            int offX = worldX + direction.x;
            int offZ = worldZ + direction.z;
            int offY = worldY + direction.y;
            int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
            int neighbourLevel = this.getLightLevel(sectionIndex, offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8);
            if (neighbourLevel - 1 <= level) continue;
            IBlockData neighbourState = this.getBlockState(offX, offY, offZ);
            if (neighbourState.starlight$isConditionallyFullOpaque()) {
                VoxelShape thisFace;
                VoxelShape neighbourFace = neighbourState.a(direction.opposite.nms);
                VoxelShape voxelShape = thisFace = conditionallyOpaqueState == null ? VoxelShapes.a() : conditionallyOpaqueState.a(direction.nms);
                if (VoxelShapes.b(thisFace, neighbourFace)) continue;
            }
            if ((level = Math.max(calculated = neighbourLevel - opacity, level)) <= expect) continue;
            return level;
        }
        return level;
    }

    @Override
    protected void propagateBlockChanges(ILightAccess lightAccess, IChunkAccess atChunk, Set<BlockPosition> positions) {
        this.rewriteNibbleCacheForSkylight(atChunk);
        Arrays.fill(this.nullPropagationCheckCache, false);
        IBlockAccess world = lightAccess.q();
        int chunkX = atChunk.f().h;
        int chunkZ = atChunk.f().i;
        int heightMapOffset = chunkX * -16 + chunkZ * -256;
        for (BlockPosition pos : positions) {
            int index = pos.u() + (pos.w() << 4) + heightMapOffset;
            int curr = this.heightMapBlockChange[index];
            if (pos.v() <= curr) continue;
            this.heightMapBlockChange[index] = pos.v();
        }
        block1: for (int index = 0; index < 256; ++index) {
            int maxY = this.heightMapBlockChange[index];
            if (maxY == Integer.MIN_VALUE) continue;
            this.heightMapBlockChange[index] = Integer.MIN_VALUE;
            int columnX = index & 0xF | chunkX << 4;
            int columnZ = index >>> 4 | chunkZ << 4;
            int maxPropagationY = this.tryPropagateSkylight(world, columnX, maxY, columnZ, true, true);
            long propagateDirection = StarLightEngine.AxisDirection.POSITIVE_Y.everythingButThisDirection;
            int encodeOffset = this.coordinateOffset;
            if (this.getLightLevelExtruded(columnX, maxPropagationY, columnZ) != 15) continue;
            this.checkNullSection(columnX >> 4, maxPropagationY >> 4, columnZ >> 4, true);
            for (int currY = maxPropagationY; currY >= this.minLightSection << 4; --currY) {
                SWMRNibbleArray nibble;
                if ((currY & 0xF) == 15) {
                    this.checkNullSection(columnX >> 4, currY >> 4, columnZ >> 4, true);
                }
                if ((nibble = this.getNibbleFromCache(columnX >> 4, currY >> 4, columnZ >> 4)) == null) {
                    currY &= 0xFFFFFFF0;
                    continue;
                }
                if (nibble.getUpdating(columnX, currY, columnZ) != 15) continue block1;
                this.appendToDecreaseQueue((long)(columnX + (columnZ << 6) + (currY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32);
            }
        }
        this.processDelayedIncreases();
        this.processDelayedDecreases();
        for (BlockPosition pos : positions) {
            this.checkBlock(lightAccess, pos.u(), pos.v(), pos.w());
        }
        this.performLightDecrease(lightAccess);
    }

    @Override
    protected void lightChunk(ILightAccess lightAccess, IChunkAccess chunk, boolean needsEdgeChecks) {
        this.rewriteNibbleCacheForSkylight(chunk);
        Arrays.fill(this.nullPropagationCheckCache, false);
        IBlockAccess world = lightAccess.q();
        ChunkCoordIntPair chunkPos = chunk.f();
        int chunkX = chunkPos.h;
        int chunkZ = chunkPos.i;
        ChunkSection[] sections = chunk.d();
        int highestNonEmptySection = this.maxSection;
        while (highestNonEmptySection == this.minSection - 1 || sections[highestNonEmptySection - this.minSection] == null || sections[highestNonEmptySection - this.minSection].c()) {
            this.checkNullSection(chunkX, highestNonEmptySection, chunkZ, false);
            for (StarLightEngine.AxisDirection direction : StarLightEngine.ONLY_HORIZONTAL_DIRECTIONS) {
                int currY;
                int startZ;
                int startX;
                int incZ;
                int incX;
                int neighbourX = chunkX + direction.x;
                int neighbourZ = chunkZ + direction.z;
                SWMRNibbleArray neighbourNibble = this.getNibbleFromCache(neighbourX, highestNonEmptySection, neighbourZ);
                if (neighbourNibble == null) continue;
                if (direction.x != 0) {
                    incX = 0;
                    incZ = 1;
                    startX = direction.x < 0 ? chunkX << 4 : chunkX << 4 | 0xF;
                    startZ = chunkZ << 4;
                } else {
                    incX = 1;
                    incZ = 0;
                    startZ = direction.z < 0 ? chunkZ << 4 : chunkZ << 4 | 0xF;
                    startX = chunkX << 4;
                }
                int encodeOffset = this.coordinateOffset;
                long propagateDirection = 1L << direction.ordinal();
                int maxY = currY | 0xF;
                for (currY = highestNonEmptySection << 4; currY <= maxY; ++currY) {
                    int i2 = 0;
                    int currX = startX;
                    int currZ = startZ;
                    while (i2 < 16) {
                        this.appendToIncreaseQueue((long)(currX + (currZ << 6) + (currY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32);
                        ++i2;
                        currX += incX;
                        currZ += incZ;
                    }
                }
            }
            if (highestNonEmptySection-- != this.minSection - 1) continue;
        }
        if (highestNonEmptySection >= this.minSection) {
            int minX = chunkPos.h << 4;
            int maxX = chunkPos.h << 4 | 0xF;
            int minZ = chunkPos.i << 4;
            int maxZ = chunkPos.i << 4 | 0xF;
            int startY = highestNonEmptySection << 4 | 0xF;
            for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                for (int currX = minX; currX <= maxX; ++currX) {
                    this.tryPropagateSkylight(world, currX, startY + 1, currZ, false, false);
                }
            }
        }
        if (needsEdgeChecks) {
            this.performLightIncrease(lightAccess);
            for (int y2 = highestNonEmptySection; y2 >= this.minLightSection; --y2) {
                this.checkNullSection(chunkX, y2, chunkZ, false);
            }
            super.checkChunkEdges(lightAccess, chunk, this.minLightSection, highestNonEmptySection);
        } else {
            for (int y3 = highestNonEmptySection; y3 >= this.minLightSection; --y3) {
                this.checkNullSection(chunkX, y3, chunkZ, false);
            }
            this.propagateNeighbourLevels(lightAccess, chunk, this.minLightSection, highestNonEmptySection);
            this.performLightIncrease(lightAccess);
        }
    }

    protected final void processDelayedIncreases() {
        long[] queue = this.increaseQueue;
        int decodeOffsetX = -this.encodeOffsetX;
        int decodeOffsetY = -this.encodeOffsetY;
        int decodeOffsetZ = -this.encodeOffsetZ;
        int len = this.increaseQueueInitialLength;
        for (int i2 = 0; i2 < len; ++i2) {
            long queueValue = queue[i2];
            int posX = ((int)queueValue & 0x3F) + decodeOffsetX;
            int posZ = ((int)queueValue >>> 6 & 0x3F) + decodeOffsetZ;
            int posY = ((int)queueValue >>> 12 & 0xFFFF) + decodeOffsetY;
            int propagatedLightLevel = (int)(queueValue >>> 28 & 0xFL);
            this.setLightLevel(posX, posY, posZ, propagatedLightLevel);
        }
    }

    protected final void processDelayedDecreases() {
        long[] queue = this.decreaseQueue;
        int decodeOffsetX = -this.encodeOffsetX;
        int decodeOffsetY = -this.encodeOffsetY;
        int decodeOffsetZ = -this.encodeOffsetZ;
        int len = this.decreaseQueueInitialLength;
        for (int i2 = 0; i2 < len; ++i2) {
            long queueValue = queue[i2];
            int posX = ((int)queueValue & 0x3F) + decodeOffsetX;
            int posZ = ((int)queueValue >>> 6 & 0x3F) + decodeOffsetZ;
            int posY = ((int)queueValue >>> 12 & 0xFFFF) + decodeOffsetY;
            this.setLightLevel(posX, posY, posZ, 0);
        }
    }

    protected final int tryPropagateSkylight(IBlockAccess world, int worldX, int startY, int worldZ, boolean extrudeInitialised, boolean delayLightSet) {
        int encodeOffset = this.coordinateOffset;
        long propagateDirection = StarLightEngine.AxisDirection.POSITIVE_Y.everythingButThisDirection;
        if (this.getLightLevelExtruded(worldX, startY + 1, worldZ) != 15) {
            return startY;
        }
        this.checkNullSection(worldX >> 4, startY >> 4, worldZ >> 4, extrudeInitialised);
        IBlockData above = this.getBlockState(worldX, startY + 1, worldZ);
        while (startY >= this.minLightSection << 4) {
            int opacity;
            VoxelShape fromShape;
            if ((startY & 0xF) == 15) {
                this.checkNullSection(worldX >> 4, startY >> 4, worldZ >> 4, extrudeInitialised);
            }
            IBlockData current = this.getBlockState(worldX, startY, worldZ);
            if (above.starlight$isConditionallyFullOpaque()) {
                fromShape = above.a(StarLightEngine.AxisDirection.NEGATIVE_Y.nms);
                if (VoxelShapes.b(VoxelShapes.a(), fromShape)) {
                    break;
                }
            } else {
                fromShape = VoxelShapes.a();
            }
            long flags = 0L;
            if (current.starlight$isConditionallyFullOpaque()) {
                VoxelShape cullingFace = current.a(StarLightEngine.AxisDirection.POSITIVE_Y.nms);
                if (VoxelShapes.b(fromShape, cullingFace)) break;
                flags |= Long.MIN_VALUE;
            }
            if ((opacity = current.g()) > 0) break;
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (startY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32 | flags);
            above = current;
            if (this.getNibbleFromCache(worldX >> 4, startY >> 4, worldZ >> 4) == null) {
                --this.increaseQueueInitialLength;
                startY &= 0xFFFFFFF0;
                above = StarLightEngine.AIR_BLOCK_STATE;
            } else if (!delayLightSet) {
                this.setLightLevel(worldX, startY, worldZ, 15);
            }
            --startY;
        }
        return startY;
    }
}

