/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.util;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Arrays;
import java.util.Objects;

public final class ParallelSearchRadiusIteration {
    private static final long[][] SEARCH_RADIUS_ITERATION_LIST = new long[MoonriseConstants.MAX_VIEW_DISTANCE + 2 + 1][];

    public static long[] getSearchIteration(int radius) {
        return SEARCH_RADIUS_ITERATION_LIST[radius];
    }

    private static int getDistanceSize(int radius, int max) {
        if (radius == 0) {
            return 1;
        }
        int diff = radius - max;
        if (diff <= 0) {
            return 4 * radius;
        }
        return 4 * (max - Math.max(0, diff - 1));
    }

    private static int getQ1DistanceSize(int radius, int max) {
        if (radius == 0) {
            return 1;
        }
        int diff = radius - max;
        if (diff <= 0) {
            return radius + 1;
        }
        return max - diff + 1;
    }

    private static CustomLongArray[] makeQ1BFS(int radius) {
        CustomLongArray[] ret = new CustomLongArray[2 * radius + 1];
        BasicFIFOLQueue queue = new BasicFIFOLQueue(Math.max(1, 4 * radius) + 1);
        LongOpenHashSet seen = new LongOpenHashSet((radius + 1) * (radius + 1));
        seen.add(CoordinateUtils.getChunkKey(0, 0));
        queue.addLast(CoordinateUtils.getChunkKey(0, 0));
        while (!queue.isEmpty()) {
            long chunk = queue.removeFirst();
            int chunkX = CoordinateUtils.getChunkX(chunk);
            int chunkZ = CoordinateUtils.getChunkZ(chunk);
            int index = Math.abs(chunkX) + Math.abs(chunkZ);
            CustomLongArray list = ret[index];
            if (list != null) {
                list.addUnchecked(chunk);
            } else {
                ret[index] = new CustomLongArray(ParallelSearchRadiusIteration.getQ1DistanceSize(index, radius));
                ret[index].addUnchecked(chunk);
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                int signInv = -(i2 >>> 1);
                int axis = i2 & 1;
                int dx = (axis - 1 ^ signInv) - signInv;
                int dz = (-axis ^ signInv) - signInv;
                int neighbourX = chunkX + dx;
                int neighbourZ = chunkZ + dz;
                long neighbour = CoordinateUtils.getChunkKey(neighbourX, neighbourZ);
                if ((neighbourX | neighbourZ) < 0 || Math.max(Math.abs(neighbourX), Math.abs(neighbourZ)) > radius || !seen.add(neighbour)) continue;
                queue.addLast(neighbour);
            }
        }
        return ret;
    }

    private static CustomLongArray spread(CustomLongArray input, int size) {
        LongLinkedOpenHashSet notAdded = new LongLinkedOpenHashSet((LongCollection)input);
        CustomLongArray added = new CustomLongArray(size);
        while (!notAdded.isEmpty()) {
            if (added.isEmpty()) {
                added.addUnchecked(notAdded.removeLastLong());
                continue;
            }
            long maxChunk = -1L;
            int maxDist = 0;
            LongListIterator iterator = notAdded.iterator();
            while (iterator.hasNext()) {
                long chunkKey = iterator.nextLong();
                int chunkX = CoordinateUtils.getChunkX(chunkKey);
                int chunkZ = CoordinateUtils.getChunkZ(chunkKey);
                int minDist = Integer.MAX_VALUE;
                int len = added.size();
                long[] addedArr = added.elements();
                Objects.checkFromToIndex(0, len, addedArr.length);
                for (int i2 = 0; i2 < len; ++i2) {
                    long addedKey = addedArr[i2];
                    int addedX = CoordinateUtils.getChunkX(addedKey);
                    int addedZ = CoordinateUtils.getChunkZ(addedKey);
                    int dist = Math.max(Math.abs(addedX - chunkX), Math.abs(addedZ - chunkZ));
                    minDist = Math.min(dist, minDist);
                }
                if (minDist <= maxDist) continue;
                maxDist = minDist;
                maxChunk = chunkKey;
            }
            if (!notAdded.remove(maxChunk)) {
                throw new IllegalStateException();
            }
            added.addUnchecked(maxChunk);
        }
        return added;
    }

    private static void expandQuadrants(CustomLongArray input, int size) {
        int len = input.size();
        long[] array = input.elements();
        int writeIndex = size - 1;
        for (int i2 = len - 1; i2 >= 0; --i2) {
            int chunkZ;
            long key = array[i2];
            int chunkX = CoordinateUtils.getChunkX(key);
            if ((chunkX | (chunkZ = CoordinateUtils.getChunkZ(key))) < 0 || i2 != 0 && chunkX == 0 && chunkZ == 0) {
                throw new IllegalStateException();
            }
            if (chunkZ != 0) {
                array[writeIndex--] = CoordinateUtils.getChunkKey(chunkX, -chunkZ);
            }
            if (chunkX != 0 && chunkZ != 0) {
                array[writeIndex--] = CoordinateUtils.getChunkKey(-chunkX, -chunkZ);
            }
            if (chunkX != 0) {
                array[writeIndex--] = CoordinateUtils.getChunkKey(-chunkX, chunkZ);
            }
            array[writeIndex--] = key;
        }
        input.forceSize(size);
        if (writeIndex != -1) {
            throw new IllegalStateException();
        }
    }

    private static long[] generateBFSOrder(int radius) {
        CustomLongArray[] byDistance = ParallelSearchRadiusIteration.makeQ1BFS(radius);
        int len = byDistance.length;
        for (int i2 = 0; i2 < len; ++i2) {
            CustomLongArray points = byDistance[i2];
            int expectedSize = ParallelSearchRadiusIteration.getDistanceSize(i2, radius);
            CustomLongArray spread = ParallelSearchRadiusIteration.spread(points, expectedSize);
            ParallelSearchRadiusIteration.expandQuadrants(spread, expectedSize);
            byDistance[i2] = spread;
        }
        CustomLongArray ret = new CustomLongArray((2 * radius + 1) * (2 * radius + 1));
        for (CustomLongArray dist : byDistance) {
            ret.addAll(dist);
        }
        return ret.elements();
    }

    static {
        for (int i2 = 0; i2 < SEARCH_RADIUS_ITERATION_LIST.length; ++i2) {
            ParallelSearchRadiusIteration.SEARCH_RADIUS_ITERATION_LIST[i2] = ParallelSearchRadiusIteration.generateBFSOrder(i2);
        }
    }

    private static class CustomLongArray
    extends LongArrayList {
        public CustomLongArray() {
        }

        public CustomLongArray(int expected) {
            super(expected);
        }

        public boolean addAll(CustomLongArray list) {
            this.addElements(this.size, list.a, 0, list.size);
            return list.size != 0;
        }

        public void addUnchecked(long value) {
            this.a[this.size++] = value;
        }

        public void forceSize(int to) {
            this.size = to;
        }

        public int hashCode() {
            long h2 = 1L;
            Objects.checkFromToIndex(0, this.size, this.a.length);
            for (int i2 = 0; i2 < this.size; ++i2) {
                h2 = HashCommon.mix((long)(h2 + this.a[i2]));
            }
            return (int)h2;
        }

        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof CustomLongArray)) {
                return false;
            }
            CustomLongArray other = (CustomLongArray)((Object)o2);
            return this.size == other.size && Arrays.equals(this.a, 0, this.size, other.a, 0, this.size);
        }
    }

    private static final class BasicFIFOLQueue {
        private final long[] values;
        private int head;
        private int tail;

        public BasicFIFOLQueue(int cap) {
            if (cap <= 1) {
                throw new IllegalArgumentException();
            }
            this.values = new long[cap];
        }

        public boolean isEmpty() {
            return this.head == this.tail;
        }

        public long removeFirst() {
            long ret = this.values[this.head];
            if (this.head == this.tail) {
                throw new IllegalStateException();
            }
            ++this.head;
            if (this.head == this.values.length) {
                this.head = 0;
            }
            return ret;
        }

        public void addLast(long value) {
            this.values[this.tail++] = value;
            if (this.tail == this.head) {
                throw new IllegalStateException();
            }
            if (this.tail == this.values.length) {
                this.tail = 0;
            }
        }
    }
}

