/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.lock.ReentrantAreaLock;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.patches.chunk_system.ChunkSystemConverters;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkProgressionTask;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.GenericDataLoadTask;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkLoadTask
extends ChunkProgressionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkLoadTask.class);
    private final NewChunkHolder chunkHolder;
    private final ChunkDataLoadTask loadTask;
    private volatile boolean cancelled;
    private NewChunkHolder.GenericDataLoadTaskCallback entityLoadTask;
    private NewChunkHolder.GenericDataLoadTaskCallback poiLoadTask;
    private GenericDataLoadTask.TaskResult<IChunkAccess, Throwable> loadResult;
    private final AtomicInteger taskCountToComplete = new AtomicInteger(3);
    private boolean scheduled;

    public ChunkLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, NewChunkHolder chunkHolder, Priority priority) {
        super(scheduler, world, chunkX, chunkZ);
        this.chunkHolder = chunkHolder;
        this.loadTask = new ChunkDataLoadTask(scheduler, world, chunkX, chunkZ, priority);
        this.loadTask.addCallback(result -> {
            this.loadResult = result;
            this.tryCompleteLoad();
        });
    }

    private void tryCompleteLoad() {
        int count = this.taskCountToComplete.decrementAndGet();
        if (count == 0) {
            GenericDataLoadTask.TaskResult<IChunkAccess, Throwable> result = this.cancelled ? null : this.loadResult;
            this.complete(result == null ? null : result.left(), result == null ? null : result.right());
        } else if (count < 0) {
            throw new IllegalStateException("Called tryCompleteLoad() too many times");
        }
    }

    @Override
    public ChunkStatus getTargetStatus() {
        return ChunkStatus.c;
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule() {
        NewChunkHolder.GenericDataLoadTaskCallback poiLoadTask;
        NewChunkHolder.GenericDataLoadTaskCallback entityLoadTask;
        Consumer<GenericDataLoadTask.TaskResult<PoiChunk, Throwable>> scheduleLoadTask = result -> this.tryCompleteLoad();
        ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            if (this.scheduled) {
                throw new IllegalStateException("schedule() called twice");
            }
            this.scheduled = true;
            if (this.cancelled) {
                return;
            }
            if (!this.chunkHolder.isEntityChunkNBTLoaded()) {
                entityLoadTask = this.chunkHolder.getOrLoadEntityData(scheduleLoadTask);
            } else {
                entityLoadTask = null;
                this.tryCompleteLoad();
            }
            if (!this.chunkHolder.isPoiChunkLoaded()) {
                poiLoadTask = this.chunkHolder.getOrLoadPoiData(scheduleLoadTask);
            } else {
                poiLoadTask = null;
                this.tryCompleteLoad();
            }
            this.entityLoadTask = entityLoadTask;
            this.poiLoadTask = poiLoadTask;
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
        if (entityLoadTask != null) {
            entityLoadTask.schedule();
        }
        if (poiLoadTask != null) {
            poiLoadTask.schedule();
        }
        this.loadTask.schedule(false);
    }

    @Override
    public void cancel() {
        boolean scheduled;
        ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            scheduled = this.scheduled;
            this.cancelled = true;
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
        if (scheduled) {
            if (this.entityLoadTask != null && this.entityLoadTask.cancel()) {
                this.tryCompleteLoad();
            }
            if (this.poiLoadTask != null && this.poiLoadTask.cancel()) {
                this.tryCompleteLoad();
            }
        } else {
            this.tryCompleteLoad();
            this.tryCompleteLoad();
        }
        this.loadTask.cancel();
    }

    @Override
    public Priority getPriority() {
        return this.loadTask.getPriority();
    }

    @Override
    public void lowerPriority(Priority priority) {
        PoiDataLoadTask poiLoad;
        EntityDataLoadTask entityLoad = this.chunkHolder.getEntityDataLoadTask();
        if (entityLoad != null) {
            entityLoad.lowerPriority(priority);
        }
        if ((poiLoad = this.chunkHolder.getPoiDataLoadTask()) != null) {
            poiLoad.lowerPriority(priority);
        }
        this.loadTask.lowerPriority(priority);
    }

    @Override
    public void setPriority(Priority priority) {
        PoiDataLoadTask poiLoad;
        EntityDataLoadTask entityLoad = this.chunkHolder.getEntityDataLoadTask();
        if (entityLoad != null) {
            entityLoad.setPriority(priority);
        }
        if ((poiLoad = this.chunkHolder.getPoiDataLoadTask()) != null) {
            poiLoad.setPriority(priority);
        }
        this.loadTask.setPriority(priority);
    }

    @Override
    public void raisePriority(Priority priority) {
        PoiDataLoadTask poiLoad;
        EntityDataLoadTask entityLoad = this.chunkHolder.getEntityDataLoadTask();
        if (entityLoad != null) {
            entityLoad.raisePriority(priority);
        }
        if ((poiLoad = this.chunkHolder.getPoiDataLoadTask()) != null) {
            poiLoad.raisePriority(priority);
        }
        this.loadTask.raisePriority(priority);
    }

    private static final class ChunkDataLoadTask
    extends CallbackDataLoadTask<ReadChunk, IChunkAccess> {
        private ChunkDataLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, Priority priority) {
            super(scheduler, world, chunkX, chunkZ, MoonriseRegionFileIO.RegionFileType.CHUNK_DATA, priority);
        }

        @Override
        protected boolean hasOffMain() {
            return true;
        }

        @Override
        protected boolean hasOnMain() {
            return true;
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOffMain(Runnable run, Priority priority) {
            return this.scheduler.loadExecutor.createTask(run, priority);
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOnMain(Runnable run, Priority priority) {
            return this.scheduler.createChunkTask(this.chunkX, this.chunkZ, run, priority);
        }

        @Override
        protected GenericDataLoadTask.TaskResult<IChunkAccess, Throwable> completeOnMainOffMain(ReadChunk data, Throwable throwable) {
            if (throwable != null) {
                return new GenericDataLoadTask.TaskResult<Object, Throwable>(null, throwable);
            }
            if (data == null || data.protoChunk() == null) {
                return new GenericDataLoadTask.TaskResult<ProtoChunk, Object>(this.getEmptyChunk(), null);
            }
            if (!PlatformHooks.get().hasMainChunkLoadHook()) {
                return new GenericDataLoadTask.TaskResult<ProtoChunk, Object>(data.protoChunk(), null);
            }
            return null;
        }

        private ProtoChunk getEmptyChunk() {
            return new ProtoChunk(new ChunkCoordIntPair(this.chunkX, this.chunkZ), ChunkConverter.a, this.world, this.world.K_().e(Registries.aI), null);
        }

        @Override
        protected GenericDataLoadTask.TaskResult<ReadChunk, Throwable> runOffMain(NBTTagCompound data, Throwable throwable) {
            if (throwable != null) {
                LOGGER.error("Failed to load chunk data for task: " + this.toString() + ", chunk data will be lost", throwable);
                return new GenericDataLoadTask.TaskResult<Object, Object>(null, null);
            }
            if (data == null) {
                return new GenericDataLoadTask.TaskResult<Object, Object>(null, null);
            }
            try {
                NBTTagCompound converted = this.world.m().a.upgradeChunkTag(data, new ChunkCoordIntPair(this.chunkX, this.chunkZ));
                SerializableChunkData chunkData = SerializableChunkData.a((LevelHeightAccessor)this.world, this.world.K_(), converted);
                if (chunkData == null) {
                    LOGGER.error("Deserialized chunk for task: " + this.toString() + " produced null, chunk data will be lost?");
                }
                ProtoChunk chunk = chunkData == null ? null : chunkData.a(this.world, this.world.A(), this.world.m().a.q(), new ChunkCoordIntPair(this.chunkX, this.chunkZ));
                return new GenericDataLoadTask.TaskResult<ReadChunk, Object>(new ReadChunk(chunk, chunkData), null);
            }
            catch (Throwable thr2) {
                LOGGER.error("Failed to parse chunk data for task: " + this.toString() + ", chunk data will be lost", thr2);
                return new GenericDataLoadTask.TaskResult<Object, Object>(null, null);
            }
        }

        @Override
        protected GenericDataLoadTask.TaskResult<IChunkAccess, Throwable> runOnMain(ReadChunk data, Throwable throwable) {
            PlatformHooks.get().mainChunkLoad(data.protoChunk(), data.chunkData());
            return new GenericDataLoadTask.TaskResult<ProtoChunk, Object>(data.protoChunk(), null);
        }
    }

    public static final class EntityDataLoadTask
    extends CallbackDataLoadTask<NBTTagCompound, NBTTagCompound> {
        public EntityDataLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, Priority priority) {
            super(scheduler, world, chunkX, chunkZ, MoonriseRegionFileIO.RegionFileType.ENTITY_DATA, priority);
        }

        @Override
        protected boolean hasOffMain() {
            return true;
        }

        @Override
        protected boolean hasOnMain() {
            return false;
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOffMain(Runnable run, Priority priority) {
            return this.scheduler.loadExecutor.createTask(run, priority);
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOnMain(Runnable run, Priority priority) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected GenericDataLoadTask.TaskResult<NBTTagCompound, Throwable> completeOnMainOffMain(NBTTagCompound data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected GenericDataLoadTask.TaskResult<NBTTagCompound, Throwable> runOffMain(NBTTagCompound data, Throwable throwable) {
            if (throwable != null) {
                LOGGER.error("Failed to load entity data for task: " + this.toString() + ", entity data will be lost", throwable);
                return new GenericDataLoadTask.TaskResult<Object, Object>(null, null);
            }
            if (data == null || data.g()) {
                return new GenericDataLoadTask.TaskResult<Object, Object>(null, null);
            }
            try {
                return new GenericDataLoadTask.TaskResult<NBTTagCompound, Object>(ChunkSystemConverters.convertEntityChunkCompoundTag(data, this.world), null);
            }
            catch (Throwable thr2) {
                LOGGER.error("Failed to run converters for entity data for task: " + this.toString() + ", entity data will be lost", thr2);
                return new GenericDataLoadTask.TaskResult<Object, Throwable>(null, thr2);
            }
        }

        @Override
        protected GenericDataLoadTask.TaskResult<NBTTagCompound, Throwable> runOnMain(NBTTagCompound data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class PoiDataLoadTask
    extends CallbackDataLoadTask<PoiChunk, PoiChunk> {
        public PoiDataLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, Priority priority) {
            super(scheduler, world, chunkX, chunkZ, MoonriseRegionFileIO.RegionFileType.POI_DATA, priority);
        }

        @Override
        protected boolean hasOffMain() {
            return true;
        }

        @Override
        protected boolean hasOnMain() {
            return false;
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOffMain(Runnable run, Priority priority) {
            return this.scheduler.loadExecutor.createTask(run, priority);
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOnMain(Runnable run, Priority priority) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected GenericDataLoadTask.TaskResult<PoiChunk, Throwable> completeOnMainOffMain(PoiChunk data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected GenericDataLoadTask.TaskResult<PoiChunk, Throwable> runOffMain(NBTTagCompound data, Throwable throwable) {
            if (throwable != null) {
                LOGGER.error("Failed to load poi data for task: " + this.toString() + ", poi data will be lost", throwable);
                return new GenericDataLoadTask.TaskResult<PoiChunk, Object>(PoiChunk.empty(this.world, this.chunkX, this.chunkZ), null);
            }
            if (data == null || data.g()) {
                return new GenericDataLoadTask.TaskResult<PoiChunk, Object>(PoiChunk.empty(this.world, this.chunkX, this.chunkZ), null);
            }
            try {
                NBTTagCompound converted = ChunkSystemConverters.convertPoiCompoundTag(data, this.world);
                return new GenericDataLoadTask.TaskResult<PoiChunk, Object>(PoiChunk.parse(this.world, this.chunkX, this.chunkZ, converted), null);
            }
            catch (Throwable thr2) {
                LOGGER.error("Failed to run parse poi data for task: " + this.toString() + ", poi data will be lost", thr2);
                return new GenericDataLoadTask.TaskResult<PoiChunk, Object>(PoiChunk.empty(this.world, this.chunkX, this.chunkZ), null);
            }
        }

        @Override
        protected GenericDataLoadTask.TaskResult<PoiChunk, Throwable> runOnMain(PoiChunk data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }
    }

    private record ReadChunk(ProtoChunk protoChunk, SerializableChunkData chunkData) {
    }

    protected static abstract class CallbackDataLoadTask<OnMain, FinalCompletion>
    extends GenericDataLoadTask<OnMain, FinalCompletion> {
        private GenericDataLoadTask.TaskResult<FinalCompletion, Throwable> result;
        private final MultiThreadedQueue<Consumer<GenericDataLoadTask.TaskResult<FinalCompletion, Throwable>>> waiters = new MultiThreadedQueue();
        protected volatile boolean completed;
        protected static final VarHandle COMPLETED_HANDLE = ConcurrentUtil.getVarHandle(CallbackDataLoadTask.class, (String)"completed", Boolean.TYPE);

        protected CallbackDataLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, MoonriseRegionFileIO.RegionFileType type, Priority priority) {
            super(scheduler, world, chunkX, chunkZ, type, priority);
        }

        public void addCallback(Consumer<GenericDataLoadTask.TaskResult<FinalCompletion, Throwable>> consumer) {
            if (!this.waiters.add(consumer)) {
                try {
                    consumer.accept(this.result);
                }
                catch (Throwable throwable) {
                    this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Consumer", ChunkTaskScheduler.stringIfNull(consumer), "Completed throwable", ChunkTaskScheduler.stringIfNull(this.result.right()), "CallbackDataLoadTask impl", this.getClass().getName()), throwable);
                }
            }
        }

        @Override
        protected void onComplete(GenericDataLoadTask.TaskResult<FinalCompletion, Throwable> result) {
            Consumer consumer;
            if (COMPLETED_HANDLE.getAndSet(this, true)) {
                throw new IllegalStateException("Already completed");
            }
            this.result = result;
            while ((consumer = (Consumer)this.waiters.pollOrBlockAdds()) != null) {
                try {
                    consumer.accept(result);
                }
                catch (Throwable throwable) {
                    this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Consumer", ChunkTaskScheduler.stringIfNull(consumer), "Completed throwable", ChunkTaskScheduler.stringIfNull(result.right()), "CallbackDataLoadTask impl", this.getClass().getName()), throwable);
                    return;
                }
            }
        }
    }
}

