/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util;

import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util.ZeroCollidingReferenceStateTable;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;

public final class ZeroCollidingReferenceStateTable<O, S> {
    private final Int2ObjectOpenHashMap<Indexer> propertyToIndexer;
    private S[] lookup;
    private final Collection<IBlockState<?>> properties;

    public ZeroCollidingReferenceStateTable(Collection<IBlockState<?>> properties) {
        this.propertyToIndexer = new Int2ObjectOpenHashMap(properties.size());
        this.properties = new ReferenceArrayList(properties);
        ArrayList sortedProperties = new ArrayList(properties);
        sortedProperties.sort((p1, p2) -> Integer.compare(p1.moonrise$getId(), p2.moonrise$getId()));
        int currentMultiple = 1;
        for (IBlockState iBlockState : sortedProperties) {
            int totalValues = iBlockState.a().size();
            this.propertyToIndexer.put(iBlockState.moonrise$getId(), (Object)new Indexer(totalValues, currentMultiple, IntegerUtil.getUnsignedDivisorMagic((long)currentMultiple, (int)32), IntegerUtil.getUnsignedDivisorMagic((long)totalValues, (int)32)));
            currentMultiple *= totalValues;
        }
    }

    public <T extends Comparable<T>> boolean hasProperty(IBlockState<T> property) {
        return this.propertyToIndexer.containsKey(property.moonrise$getId());
    }

    public long getIndex(IBlockDataHolder<O, S> stateHolder) {
        long ret = 0L;
        for (Map.Entry<IBlockState<?>, Comparable<?>> entry : stateHolder.G().entrySet()) {
            IBlockState<?> property = entry.getKey();
            Comparable<?> value = entry.getValue();
            Indexer indexer = (Indexer)this.propertyToIndexer.get(property.moonrise$getId());
            ret += (long)(property.moonrise$getIdFor(value) * indexer.multiple);
        }
        return ret;
    }

    public boolean isLoaded() {
        return this.lookup != null;
    }

    public void loadInTable(Map<Map<IBlockState<?>, Comparable<?>>, S> universe) {
        if (this.lookup != null) {
            throw new IllegalStateException();
        }
        this.lookup = new IBlockDataHolder[universe.size()];
        for (Map.Entry<Map<IBlockState<?>, Comparable<?>>, S> entry : universe.entrySet()) {
            S value = entry.getValue();
            if (value == null) continue;
            this.lookup[(int)((IBlockDataHolder)value).moonrise$getTableIndex()] = value;
        }
        for (S value : this.lookup) {
            if (value != null) continue;
            throw new IllegalStateException();
        }
    }

    public <T extends Comparable<T>> T get(long index, IBlockState<T> property) {
        Indexer indexer = (Indexer)this.propertyToIndexer.get(property.moonrise$getId());
        if (indexer == null) {
            return null;
        }
        long divided = index * indexer.multipleDivMagic >>> 32;
        long modded = (divided * indexer.modMagic & 0xFFFFFFFFL) * (long)indexer.totalValues >>> 32;
        return (T)((Comparable)property.moonrise$getById((int)modded));
    }

    public <T extends Comparable<T>> S set(long index, IBlockState<T> property, T with) {
        int newValueId = property.moonrise$getIdFor(with);
        if (newValueId < 0) {
            return null;
        }
        Indexer indexer = (Indexer)this.propertyToIndexer.get(property.moonrise$getId());
        if (indexer == null) {
            return null;
        }
        long divided = index * indexer.multipleDivMagic >>> 32;
        long modded = (divided * indexer.modMagic & 0xFFFFFFFFL) * (long)indexer.totalValues >>> 32;
        long newIndex = ((long)newValueId - modded) * (long)indexer.multiple + index;
        return this.lookup[(int)newIndex];
    }

    public <T extends Comparable<T>> S trySet(long index, IBlockState<T> property, T with, S dfl) {
        Indexer indexer = (Indexer)this.propertyToIndexer.get(property.moonrise$getId());
        if (indexer == null) {
            return dfl;
        }
        int newValueId = property.moonrise$getIdFor(with);
        if (newValueId < 0) {
            return null;
        }
        long divided = index * indexer.multipleDivMagic >>> 32;
        long modded = (divided * indexer.modMagic & 0xFFFFFFFFL) * (long)indexer.totalValues >>> 32;
        long newIndex = ((long)newValueId - modded) * (long)indexer.multiple + index;
        return this.lookup[(int)newIndex];
    }

    public Collection<IBlockState<?>> getProperties() {
        return Collections.unmodifiableCollection(this.properties);
    }

    public Map<IBlockState<?>, Comparable<?>> getMapView(long stateIndex) {
        return new MapView(stateIndex);
    }

    private record Indexer(int totalValues, int multiple, long multipleDivMagic, long modMagic) {
    }

    private class MapView
    extends AbstractReference2ObjectMap<IBlockState<?>, Comparable<?>> {
        private final long stateIndex;
        private ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util.ZeroCollidingReferenceStateTable$MapView.EntrySet entrySet;

        MapView(long stateIndex) {
            this.stateIndex = stateIndex;
        }

        public boolean containsKey(Object key) {
            IBlockState prop;
            return key instanceof IBlockState && ZeroCollidingReferenceStateTable.this.hasProperty(prop = (IBlockState)key);
        }

        public int size() {
            return ZeroCollidingReferenceStateTable.this.properties.size();
        }

        public ObjectSet<Reference2ObjectMap.Entry<IBlockState<?>, Comparable<?>>> reference2ObjectEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = new EntrySet();
            }
            return this.entrySet;
        }

        public Comparable<?> get(Object key) {
            Comparable<?> comparable;
            if (key instanceof IBlockState) {
                IBlockState prop = (IBlockState)key;
                comparable = (Comparable<?>)ZeroCollidingReferenceStateTable.this.get(this.stateIndex, prop);
            } else {
                comparable = null;
            }
            return comparable;
        }

        class EntrySet
        extends AbstractObjectSet<Reference2ObjectMap.Entry<IBlockState<?>, Comparable<?>>> {
            EntrySet() {
            }

            public ObjectIterator<Reference2ObjectMap.Entry<IBlockState<?>, Comparable<?>>> iterator() {
                final Iterator<IBlockState<?>> propIterator = ZeroCollidingReferenceStateTable.this.properties.iterator();
                return new ObjectIterator<Reference2ObjectMap.Entry<IBlockState<?>, Comparable<?>>>(){

                    public boolean hasNext() {
                        return propIterator.hasNext();
                    }

                    public Reference2ObjectMap.Entry<IBlockState<?>, Comparable<?>> next() {
                        IBlockState prop = (IBlockState)propIterator.next();
                        return new AbstractReference2ObjectMap.BasicEntry((Object)prop, ZeroCollidingReferenceStateTable.this.get(MapView.this.stateIndex, prop));
                    }
                };
            }

            public int size() {
                return ZeroCollidingReferenceStateTable.this.properties.size();
            }
        }
    }
}

