/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.map;

import it.unimi.dsi.fastutil.longs.Long2IntFunction;
import java.util.Arrays;

public class Long2IntArraySortedMap {
    protected long[] key = new long[8];
    protected int[] val = new int[8];
    protected int size;

    public int put(long key, int value) {
        int index = Arrays.binarySearch(this.key, 0, this.size, key);
        if (index >= 0) {
            int current = this.val[index];
            this.val[index] = value;
            return current;
        }
        int insert = -(index + 1);
        if (this.size >= this.val.length) {
            this.key = Arrays.copyOf(this.key, this.key.length * 2);
            this.val = Arrays.copyOf(this.val, this.val.length * 2);
        }
        System.arraycopy(this.key, insert, this.key, insert + 1, this.size - insert);
        System.arraycopy(this.val, insert, this.val, insert + 1, this.size - insert);
        ++this.size;
        this.key[insert] = key;
        this.val[insert] = value;
        return 0;
    }

    public int computeIfAbsent(long key, Long2IntFunction producer) {
        int index = Arrays.binarySearch(this.key, 0, this.size, key);
        if (index >= 0) {
            return this.val[index];
        }
        int insert = -(index + 1);
        if (this.size >= this.val.length) {
            this.key = Arrays.copyOf(this.key, this.key.length * 2);
            this.val = Arrays.copyOf(this.val, this.val.length * 2);
        }
        System.arraycopy(this.key, insert, this.key, insert + 1, this.size - insert);
        System.arraycopy(this.val, insert, this.val, insert + 1, this.size - insert);
        ++this.size;
        this.key[insert] = key;
        this.val[insert] = (Integer)producer.apply((Object)key);
        return this.val[insert];
    }

    public int get(long key) {
        int index = Arrays.binarySearch(this.key, 0, this.size, key);
        if (index < 0) {
            return 0;
        }
        return this.val[index];
    }

    public int getFloor(long key) {
        int index = Arrays.binarySearch(this.key, 0, this.size, key);
        if (index < 0) {
            int insert = -(index + 1) - 1;
            return insert < 0 ? 0 : this.val[insert];
        }
        return this.val[index];
    }
}

