/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.util;

import java.util.Arrays;
import java.util.function.LongFunction;

public class Long2ObjectArraySortedMap<V> {
    protected long[] key = new long[8];
    protected V[] val = new Object[8];
    protected int size;

    public V put(long key, V value) {
        int index = Arrays.binarySearch(this.key, 0, this.size, key);
        if (index >= 0) {
            V current = this.val[index];
            this.val[index] = value;
            return current;
        }
        int insert = -(index + 1);
        if (this.size >= this.val.length) {
            this.key = Arrays.copyOf(this.key, this.key.length * 2);
            this.val = Arrays.copyOf(this.val, this.val.length * 2);
        }
        System.arraycopy(this.key, insert, this.key, insert + 1, this.size - insert);
        System.arraycopy(this.val, insert, this.val, insert + 1, this.size - insert);
        ++this.size;
        this.key[insert] = key;
        this.val[insert] = value;
        return null;
    }

    public V computeIfAbsent(long key, LongFunction<V> producer) {
        int index = Arrays.binarySearch(this.key, 0, this.size, key);
        if (index >= 0) {
            return this.val[index];
        }
        int insert = -(index + 1);
        if (this.size >= this.val.length) {
            this.key = Arrays.copyOf(this.key, this.key.length * 2);
            this.val = Arrays.copyOf(this.val, this.val.length * 2);
        }
        System.arraycopy(this.key, insert, this.key, insert + 1, this.size - insert);
        System.arraycopy(this.val, insert, this.val, insert + 1, this.size - insert);
        ++this.size;
        this.key[insert] = key;
        this.val[insert] = producer.apply(key);
        return this.val[insert];
    }

    public V get(long key) {
        int index = Arrays.binarySearch(this.key, 0, this.size, key);
        if (index < 0) {
            return null;
        }
        return this.val[index];
    }

    public V getFloor(long key) {
        int index = Arrays.binarySearch(this.key, 0, this.size, key);
        if (index < 0) {
            int insert = -(index + 1) - 1;
            return insert < 0 ? null : (V)this.val[insert];
        }
        return this.val[index];
    }
}

