/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.util;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.custom.V3818_Commands;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.Pair;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.CommandExecute;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Nullable;

public final class CommandArgumentUpgrader {
    private final CommandDispatcher<CommandListenerWrapper> dispatcher;
    private final CommandBuildContext context;
    private final CommandListenerWrapper source;
    private final Map<Class<?>, BiFunction<ArgumentType<?>, CommandBuildContext, ArgumentType<?>>> replacements;

    public static CommandArgumentUpgrader upgrader_1_20_4_to_1_20_5(int functionPermissionLevel) {
        return new CommandArgumentUpgrader(functionPermissionLevel, builder -> {
            builder.registerReplacement(ArgumentItemStack.class, (argument, ctx) -> new ItemParser_1_20_4());
            builder.registerReplacement(ArgumentChatComponent.class, (argument, ctx) -> new ComponentParser_1_20_4());
            builder.registerReplacement(ArgumentTile.class, (argument, ctx) -> new BlockStateParser_1_20_4());
            builder.registerExtraCommand(CommandArgumentUpgrader::registerSummon_1_20_4_to_1_20_5);
        });
    }

    public CommandArgumentUpgrader(int functionPermissionLevel, Consumer<ReplacementsBuilder> consumer) {
        this(new net.minecraft.commands.CommandDispatcher(CommandDispatcher.ServerType.b, CommandArgumentUpgrader.makeDummyCommandBuildContext()).a(), functionPermissionLevel, consumer);
    }

    private CommandArgumentUpgrader(CommandDispatcher<CommandListenerWrapper> dispatcher, int functionPermissionLevel, Consumer<ReplacementsBuilder> consumer) {
        ReplacementsBuilder builder = new ReplacementsBuilder();
        consumer.accept(builder);
        this.replacements = Map.copyOf(builder.replacements);
        CommandBuildContext context = CommandArgumentUpgrader.makeDummyCommandBuildContext();
        this.dispatcher = new CommandDispatcher();
        this.context = context;
        ArrayList<CommandNode<CommandListenerWrapper>> aliases = new ArrayList<CommandNode<CommandListenerWrapper>>();
        for (CommandNode commandNode : dispatcher.getRoot().getChildren()) {
            CopyResult result = this.copyCommand((CommandNode<CommandListenerWrapper>)this.dispatcher.getRoot(), commandNode, null);
            if (result.replaced()) {
                this.dispatcher.getRoot().addChild(result.root);
            }
            aliases.addAll(result.aliases);
        }
        aliases.forEach(redirectNode -> {
            CommandNode toNode = this.dispatcher.getRoot().getChild(redirectNode.getRedirect().getName());
            if (toNode != null) {
                this.dispatcher.getRoot().addChild(new LiteralCommandNode(redirectNode.getName(), null, toNode.getRequirement(), toNode, redirectNode.getRedirectModifier(), redirectNode.isFork()));
            }
        });
        for (Consumer consumer2 : builder.extra) {
            consumer2.accept(this.dispatcher);
        }
        CommandExecute.a(this.dispatcher, context);
        ReturnCommand.a(this.dispatcher);
        this.source = new CommandListenerWrapper(ICommandListener.a, Vec3D.c, Vec2F.a, null, functionPermissionLevel, "", CommonComponents.a, null, null);
    }

    private static String blockToTileEntity(String block) {
        return switch (block) {
            case "minecraft:acacia_sign", "minecraft:jungle_wall_sign", "minecraft:oak_sign", "minecraft:cherry_sign", "minecraft:birch_wall_sign", "minecraft:dark_oak_sign", "minecraft:mangrove_wall_sign", "minecraft:cherry_wall_sign", "minecraft:jungle_sign", "minecraft:mangrove_sign", "minecraft:spruce_wall_sign", "minecraft:crimson_sign", "minecraft:oak_wall_sign", "minecraft:crimson_wall_sign", "minecraft:bamboo_sign", "minecraft:warped_wall_sign", "minecraft:bamboo_wall_sign", "minecraft:acacia_wall_sign", "minecraft:spruce_sign", "minecraft:warped_sign", "minecraft:dark_oak_wall_sign", "minecraft:birch_sign" -> "minecraft:sign";
            case "minecraft:acacia_hanging_sign", "minecraft:crimson_wall_hanging_sign", "minecraft:jungle_wall_hanging_sign", "minecraft:dark_oak_wall_hanging_sign", "minecraft:crimson_hanging_sign", "minecraft:bamboo_wall_hanging_sign", "minecraft:bamboo_hanging_sign", "minecraft:oak_wall_hanging_sign", "minecraft:cherry_wall_hanging_sign", "minecraft:warped_wall_hanging_sign", "minecraft:birch_hanging_sign", "minecraft:mangrove_hanging_sign", "minecraft:birch_wall_hanging_sign", "minecraft:jungle_hanging_sign", "minecraft:cherry_hanging_sign", "minecraft:spruce_hanging_sign", "minecraft:warped_hanging_sign", "minecraft:mangrove_wall_hanging_sign", "minecraft:spruce_wall_hanging_sign", "minecraft:dark_oak_hanging_sign", "minecraft:oak_hanging_sign", "minecraft:acacia_wall_hanging_sign" -> "minecraft:hanging_sign";
            case "minecraft:spawner" -> "minecraft:mob_spawner";
            case "minecraft:moving_piston" -> "minecraft:piston";
            case "minecraft:skeleton_skull", "minecraft:skeleton_wall_skull", "minecraft:player_wall_head", "minecraft:creeper_wall_head", "minecraft:zombie_head", "minecraft:wither_skeleton_skull", "minecraft:creeper_head", "minecraft:wither_skeleton_wall_skull", "minecraft:dragon_head", "minecraft:piglin_wall_head", "minecraft:dragon_wall_head", "minecraft:player_head", "minecraft:zombie_wall_head", "minecraft:piglin_head" -> "minecraft:skull";
            case "minecraft:black_banner", "minecraft:orange_wall_banner", "minecraft:gray_wall_banner", "minecraft:magenta_banner", "minecraft:red_banner", "minecraft:brown_wall_banner", "minecraft:pink_banner", "minecraft:light_blue_banner", "minecraft:cyan_wall_banner", "minecraft:purple_banner", "minecraft:brown_banner", "minecraft:light_gray_wall_banner", "minecraft:black_wall_banner", "minecraft:gray_banner", "minecraft:yellow_wall_banner", "minecraft:light_gray_banner", "minecraft:red_wall_banner", "minecraft:light_blue_wall_banner", "minecraft:pink_wall_banner", "minecraft:white_banner", "minecraft:green_wall_banner", "minecraft:white_wall_banner", "minecraft:magenta_wall_banner", "minecraft:green_banner", "minecraft:orange_banner", "minecraft:blue_wall_banner", "minecraft:cyan_banner", "minecraft:purple_wall_banner", "minecraft:lime_wall_banner", "minecraft:yellow_banner", "minecraft:lime_banner", "minecraft:blue_banner" -> "minecraft:banner";
            case "minecraft:repeating_command_block", "minecraft:chain_command_block" -> "minecraft:command_block";
            case "minecraft:brown_shulker_box", "minecraft:light_blue_shulker_box", "minecraft:white_shulker_box", "minecraft:green_shulker_box", "minecraft:black_shulker_box", "minecraft:lime_shulker_box", "minecraft:pink_shulker_box", "minecraft:light_gray_shulker_box", "minecraft:magenta_shulker_box", "minecraft:orange_shulker_box", "minecraft:purple_shulker_box", "minecraft:cyan_shulker_box", "minecraft:yellow_shulker_box", "minecraft:red_shulker_box", "minecraft:blue_shulker_box", "minecraft:gray_shulker_box" -> "minecraft:shulker_box";
            case "minecraft:purple_bed", "minecraft:light_blue_bed", "minecraft:yellow_bed", "minecraft:orange_bed", "minecraft:light_gray_bed", "minecraft:red_bed", "minecraft:gray_bed", "minecraft:brown_bed", "minecraft:cyan_bed", "minecraft:magenta_bed", "minecraft:green_bed", "minecraft:white_bed", "minecraft:black_bed", "minecraft:blue_bed", "minecraft:pink_bed", "minecraft:lime_bed" -> "minecraft:bed";
            case "minecraft:soul_campfire" -> "minecraft:campfire";
            case "minecraft:bee_nest" -> "minecraft:beehive";
            case "minecraft:suspicious_sand", "minecraft:suspicious_gravel" -> "minecraft:brushable_block";
            default -> block;
        };
    }

    public String upgradeCommandArguments(String command, boolean leadingSlash) {
        ParseResults<CommandListenerWrapper> parseResult;
        com.mojang.brigadier.StringReader reader = new com.mojang.brigadier.StringReader(command);
        if (leadingSlash && reader.peek() == '/') {
            reader.skip();
        }
        if (!(parseResult = this.dispatcher.parse(reader, this.source)).getExceptions().isEmpty()) {
            return command;
        }
        LinkedHashMap<StringRange, String> replacements = new LinkedHashMap<StringRange, String>();
        ArrayList mergedArguments = new ArrayList();
        CommandArgumentUpgrader.addArguments(mergedArguments, (CommandContextBuilder<CommandListenerWrapper>)parseResult.getContext());
        for (int i2 = 0; i2 < mergedArguments.size(); ++i2) {
            Pair pair = (Pair)mergedArguments.get(i2);
            Object object = ((ParsedArgument)pair.value()).getResult();
            if (object instanceof UpgradedArgument) {
                UpgradedArgument upgraded = (UpgradedArgument)object;
                replacements.put(((ParsedArgument)pair.value()).getRange(), upgraded.upgraded());
                continue;
            }
            object = ((ParsedArgument)pair.value()).getResult();
            if (!(object instanceof UpgradableArgument)) continue;
            UpgradableArgument upgradable = (UpgradableArgument)object;
            replacements.put(((ParsedArgument)pair.value()).getRange(), upgradable.upgrade(i2, mergedArguments));
        }
        Object upgradedCommand = command;
        while (!replacements.isEmpty()) {
            Map.Entry next = replacements.entrySet().iterator().next();
            replacements.remove(next.getKey());
            upgradedCommand = ((String)upgradedCommand).substring(0, ((StringRange)next.getKey()).getStart()) + (String)next.getValue() + ((String)upgradedCommand).substring(((StringRange)next.getKey()).getEnd());
            int diff = ((String)next.getValue()).length() - ((StringRange)next.getKey()).getLength();
            LinkedHashMap<StringRange, String> replacementsCopy = new LinkedHashMap<StringRange, String>(replacements);
            replacements.clear();
            replacementsCopy.forEach((range, value) -> replacements.put(new StringRange(range.getStart() + diff, range.getEnd() + diff), (String)value));
        }
        return upgradedCommand;
    }

    public String upgradeSingleArgument(Function<CommandBuildContext, ? extends ArgumentType<?>> argumentFactory, String input) {
        ArgumentType<?> replaced;
        ArgumentType<?> argument = argumentFactory.apply(this.context);
        if (argument == (replaced = this.replaceArgumentType(this.context, argument))) {
            return input;
        }
        try {
            UpgradedArgument parsed = (UpgradedArgument)replaced.parse(new com.mojang.brigadier.StringReader(input));
            return parsed.upgraded();
        }
        catch (CommandSyntaxException e2) {
            return input;
        }
    }

    private static void addArguments(List<Pair<String, ParsedArgument<CommandListenerWrapper, ?>>> mergedArguments, @Nullable CommandContextBuilder<CommandListenerWrapper> context) {
        if (context == null) {
            return;
        }
        context.getArguments().forEach((name, argument) -> mergedArguments.add(Pair.of((Object)name, (Object)argument)));
        CommandArgumentUpgrader.addArguments(mergedArguments, (CommandContextBuilder<CommandListenerWrapper>)context.getChild());
    }

    private ArgumentType<?> replaceArgumentType(CommandBuildContext ctx, ArgumentType<?> type) {
        BiFunction<ArgumentType<?>, CommandBuildContext, ArgumentType<?>> upgrader = this.replacements.get(type.getClass());
        if (upgrader != null) {
            return upgrader.apply(type, ctx);
        }
        return type;
    }

    private CopyResult copyCommand(CommandNode<CommandListenerWrapper> parent, CommandNode<CommandListenerWrapper> node, @Nullable CopyResult result) {
        boolean replaced;
        ArgumentCommandNode copy;
        if (node instanceof LiteralCommandNode) {
            LiteralCommandNode literal = (LiteralCommandNode)node;
            if (node.getName().equals("execute") || node.getName().equals("return")) {
                return new CopyResult(parent, false, new ArrayList<CommandNode<CommandListenerWrapper>>());
            }
            if (node.getRedirect() != null) {
                if (result != null) {
                    throw new IllegalStateException("Cannot handle non-root redirects");
                }
                ArrayList<CommandNode<CommandListenerWrapper>> aliases = new ArrayList<CommandNode<CommandListenerWrapper>>();
                aliases.add(node);
                return new CopyResult(parent, false, aliases);
            }
            copy = new LiteralCommandNode(literal.getLiteral(), node.getCommand(), node.getRequirement(), null, node.getRedirectModifier(), node.isFork());
            replaced = false;
        } else if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argument = (ArgumentCommandNode)node;
            ArgumentType<?> replacedType = this.replaceArgumentType(this.context, argument.getType());
            replaced = replacedType != argument.getType();
            copy = new ArgumentCommandNode(node.getName(), replacedType, node.getCommand(), node.getRequirement(), null, node.getRedirectModifier(), node.isFork(), argument.getCustomSuggestions());
        } else {
            throw new UnsupportedOperationException();
        }
        if (result == null) {
            result = new CopyResult((CommandNode<CommandListenerWrapper>)copy, false, new ArrayList<CommandNode<CommandListenerWrapper>>());
        }
        if (replaced) {
            result = result.replacedResult();
        }
        for (CommandNode<CommandListenerWrapper> child : node.getChildren()) {
            result = this.copyCommand((CommandNode<CommandListenerWrapper>)copy, child, result);
        }
        if (parent != this.dispatcher.getRoot()) {
            parent.addChild((CommandNode<CommandListenerWrapper>)copy);
        }
        return result;
    }

    public static void registerSummon_1_20_4_to_1_20_5(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("summon").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("entity", ArgumentMinecraftKeyRegistered.a()).executes(commandContext -> 1)).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).executes(commandContext -> 1)).then(net.minecraft.commands.CommandDispatcher.a("nbt", new ArgumentType<UpgradableArgument>(){

            public UpgradableArgument parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
                NBTTagCompound tag = ArgumentNBTTag.a().a(reader);
                return (index, args) -> {
                    NBTTagCompound tagCopy = tag.i();
                    Pair entityTypePair = (Pair)args.get(index - 2);
                    MinecraftKey entityType = (MinecraftKey)((ParsedArgument)entityTypePair.value()).getResult();
                    tagCopy.a("id", entityType.toString());
                    NBTTagCompound convertedTag = MCDataConverter.convertTag(MCTypeRegistry.ENTITY, tagCopy, 3700, SharedConstants.b().d().c());
                    convertedTag.r("id");
                    return convertedTag.toString();
                };
            }
        }).executes(commandContext -> 1))))));
    }

    private static CommandBuildContext makeDummyCommandBuildContext() {
        return net.minecraft.commands.CommandDispatcher.a(new HolderLookup.a(){

            @Override
            public Stream<ResourceKey<? extends IRegistry<?>>> b() {
                return Stream.of(new ResourceKey[0]);
            }

            public <T> Optional<HolderLookup.b<T>> a(final ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                return Optional.of(new HolderLookup.b<T>(){

                    @Override
                    public ResourceKey<? extends IRegistry<? extends T>> g() {
                        return registryRef;
                    }

                    @Override
                    public Lifecycle h() {
                        return Lifecycle.stable();
                    }

                    @Override
                    public Stream<Holder.c<T>> c() {
                        return Stream.of(new Holder.c[0]);
                    }

                    @Override
                    public Stream<HolderSet.Named<T>> e() {
                        return Stream.of(new HolderSet.Named[0]);
                    }

                    @Override
                    public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                        return Optional.of(Holder.c.a(this, key));
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                        return Optional.of(HolderSet.a(this, tag));
                    }
                });
            }
        });
    }

    public static final class ReplacementsBuilder {
        private final Map<Class<?>, BiFunction<ArgumentType<?>, CommandBuildContext, ArgumentType<?>>> replacements = new HashMap();
        private final List<Consumer<CommandDispatcher<CommandListenerWrapper>>> extra = new ArrayList<Consumer<CommandDispatcher<CommandListenerWrapper>>>();

        private ReplacementsBuilder() {
        }

        public <A extends ArgumentType<?>> void registerReplacement(Class<A> type, BiFunction<A, CommandBuildContext, ? extends ArgumentType<UpgradedArgument>> upgrader) {
            this.replacements.put(type, upgrader);
        }

        public void registerExtraCommand(Consumer<CommandDispatcher<CommandListenerWrapper>> consumer) {
            this.extra.add(consumer);
        }
    }

    record CopyResult(CommandNode<CommandListenerWrapper> root, boolean replaced, List<CommandNode<CommandListenerWrapper>> aliases) {
        CopyResult replacedResult() {
            if (this.replaced) {
                return this;
            }
            return new CopyResult(this.root, true, new ArrayList<CommandNode<CommandListenerWrapper>>(this.aliases));
        }
    }

    public record UpgradedArgument(String upgraded) {
    }

    public static interface UpgradableArgument {
        public String upgrade(int var1, List<Pair<String, ParsedArgument<CommandListenerWrapper, ?>>> var2);
    }

    private static class BlockStateParser_1_20_4
    implements ArgumentType<UpgradedArgument> {
        private BlockStateParser_1_20_4() {
        }

        public UpgradedArgument parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
            boolean missId;
            String block = MinecraftKey.a(reader).toString();
            StringBuilder properties = new StringBuilder();
            if (reader.canRead() && reader.peek() == '[') {
                char c2;
                do {
                    c2 = reader.read();
                    properties.append(c2);
                } while (reader.canRead() && c2 != ']');
            }
            if (!reader.canRead() || reader.peek() != '{') {
                return new UpgradedArgument(block + String.valueOf(properties));
            }
            NBTTagCompound tag = new MojangsonParser(reader).f();
            boolean bl = missId = !tag.b("id", 8);
            if (missId) {
                tag.a("id", CommandArgumentUpgrader.blockToTileEntity(block));
            }
            tag = MCDataConverter.convertTag(MCTypeRegistry.TILE_ENTITY, tag, 3700, SharedConstants.b().d().c());
            if (missId) {
                tag.r("id");
            }
            return new UpgradedArgument(block + String.valueOf(properties) + String.valueOf(tag));
        }
    }

    private static final class ComponentParser_1_20_4
    implements ArgumentType<UpgradedArgument> {
        private static final Field JSON_READER_POS = SystemUtils.a(() -> {
            try {
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException var1) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", var1);
            }
        });
        private static final Field JSON_READER_LINESTART = SystemUtils.a(() -> {
            try {
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException var1) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", var1);
            }
        });

        private ComponentParser_1_20_4() {
        }

        public UpgradedArgument parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
            JsonElement element;
            try {
                element = ComponentParser_1_20_4.parseJson(reader);
            }
            catch (Exception e2) {
                throw new SimpleCommandExceptionType((Message)new LiteralMessage(e2.getMessage())).createWithContext((ImmutableStringReader)reader);
            }
            V3818_Commands.walkComponent(element);
            return new UpgradedArgument(ChatDeserializer.e(element));
        }

        public static JsonElement parseJson(com.mojang.brigadier.StringReader stringReader) {
            JsonElement jsonElement;
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(stringReader.getRemaining()));
            jsonReader.setLenient(false);
            try {
                jsonElement = Streams.parse((JsonReader)jsonReader);
            }
            catch (StackOverflowError var9) {
                throw new JsonParseException((Throwable)var9);
            }
            finally {
                stringReader.setCursor(stringReader.getCursor() + ComponentParser_1_20_4.getPos(jsonReader));
            }
            return jsonElement;
        }

        private static int getPos(JsonReader jsonReader) {
            try {
                return JSON_READER_POS.getInt(jsonReader) - JSON_READER_LINESTART.getInt(jsonReader);
            }
            catch (IllegalAccessException var2) {
                throw new IllegalStateException("Couldn't read position of JsonReader", var2);
            }
        }
    }

    private static final class ItemParser_1_20_4
    implements ArgumentType<UpgradedArgument> {
        private ItemParser_1_20_4() {
        }

        public UpgradedArgument parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
            MinecraftKey id = MinecraftKey.a(reader);
            NBTTagCompound itemNBT = new NBTTagCompound();
            itemNBT.a("id", id.toString());
            itemNBT.a("Count", 1);
            if (reader.canRead() && reader.peek() == '{') {
                itemNBT.a("tag", new MojangsonParser(reader).f());
            }
            NBTTagCompound converted = MCDataConverter.convertTag(MCTypeRegistry.ITEM_STACK, itemNBT, 3700, SharedConstants.b().d().c());
            String newId = converted.l("id");
            if (converted.b("components", 10)) {
                return new UpgradedArgument(newId + V3818_Commands.toCommandFormat(converted.p("components")));
            }
            return new UpgradedArgument(newId);
        }
    }
}

