/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.leveldat.ConverterRemoveFeatureFlag;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class V4067 {
    private static final int VERSION = 4067;
    private static final BoatType[] BOAT_TYPES = new BoatType[]{new BoatType("oak", "boat"), new BoatType("spruce", "boat"), new BoatType("birch", "boat"), new BoatType("jungle", "boat"), new BoatType("acacia", "boat"), new BoatType("cherry", "boat"), new BoatType("dark_oak", "boat"), new BoatType("mangrove", "boat"), new BoatType("bamboo", "raft")};

    private static void registerChestBoat(String id) {
        MCTypeRegistry.ENTITY.addWalker(4067, id, new DataWalkerItemLists("Items"));
    }

    public static void register() {
        V4067.registerChestBoat("minecraft:oak_chest_boat");
        V4067.registerChestBoat("minecraft:spruce_chest_boat");
        V4067.registerChestBoat("minecraft:birch_chest_boat");
        V4067.registerChestBoat("minecraft:jungle_chest_boat");
        V4067.registerChestBoat("minecraft:acacia_chest_boat");
        V4067.registerChestBoat("minecraft:cherry_chest_boat");
        V4067.registerChestBoat("minecraft:dark_oak_chest_boat");
        V4067.registerChestBoat("minecraft:mangrove_chest_boat");
        V4067.registerChestBoat("minecraft:bamboo_chest_raft");
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(4067){
            private static final Map<String, String> BOAT_TYPES_BY_ITEM_ID = new HashMap<String, String>();

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String id = data.getString("id");
                String boatType = BOAT_TYPES_BY_ITEM_ID.get(id);
                if (boatType == null) {
                    return null;
                }
                MapType components = data.getMap("components");
                if (components == null) {
                    return null;
                }
                MapType entityData = components.getMap("minecraft:entity_data");
                if (entityData == null) {
                    return null;
                }
                entityData.setString("Type", boatType);
                return null;
            }

            static {
                for (BoatType boatType : BOAT_TYPES) {
                    BOAT_TYPES_BY_ITEM_ID.put(boatType.name() + "_" + boatType.suffix(), boatType.name());
                    BOAT_TYPES_BY_ITEM_ID.put(boatType.name() + "_chest_" + boatType.suffix(), boatType.name());
                }
            }
        });
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(4067){
            private static final Map<String, String> NORMAL_REMAPPING = new HashMap<String, String>(BOAT_TYPES.length);
            private static final Map<String, String> CHEST_REMAPPING;

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String id = data.getString("id");
                if (id == null) {
                    return null;
                }
                boolean normalBoat = id.equals("minecraft:boat");
                boolean chestBoat = id.equals("minecraft:chest_boat");
                if (!normalBoat && !chestBoat) {
                    return null;
                }
                String type = data.getString("Type");
                data.remove("Type");
                if (normalBoat) {
                    data.setString("id", NORMAL_REMAPPING.getOrDefault(type, "minecraft:oak_boat"));
                } else {
                    data.setString("id", CHEST_REMAPPING.getOrDefault(type, "minecraft:oak_chest_boat"));
                }
                return null;
            }

            static {
                for (BoatType type : BOAT_TYPES) {
                    NORMAL_REMAPPING.put(type.name(), type.name() + "_" + type.suffix());
                }
                CHEST_REMAPPING = new HashMap<String, String>(BOAT_TYPES.length);
                for (BoatType type : BOAT_TYPES) {
                    CHEST_REMAPPING.put(type.name(), type.name() + "_chest_" + type.suffix());
                }
            }
        });
        MCTypeRegistry.LEVEL.addStructureConverter(new ConverterRemoveFeatureFlag(4067, new HashSet<String>(Arrays.asList("minecraft:bundle"))));
    }

    private V4067() {
    }

    private record BoatType(String name, String suffix) {
    }
}

