/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.converters.datatypes.DataWalker;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;

public final class V4059 {
    private static final int VERSION = 4059;

    public static void register() {
        MCTypeRegistry.DATA_COMPONENTS.addStructureWalker(4059, new DataWalker<MapType<String>>(){

            private static void walkBlockPredicates(MapType<String> root, long fromVersion, long toVersion) {
                if (root.hasKey("blocks", ObjectType.STRING)) {
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, root, "blocks", fromVersion, toVersion);
                } else if (root.hasKey("blocks", ObjectType.LIST)) {
                    WalkerUtils.convertList(MCTypeRegistry.BLOCK_NAME, root, "blocks", fromVersion, toVersion);
                }
            }

            @Override
            public MapType<String> walk(MapType<String> root, long fromVersion, long toVersion) {
                MapType<String> canPlaceOn;
                WalkerUtils.convertListPath(MCTypeRegistry.ENTITY, root, "minecraft:bees", "entity_data", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.TILE_ENTITY, root, "minecraft:block_entity_data", fromVersion, toVersion);
                WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, root, "minecraft:bundle_contents", fromVersion, toVersion);
                MapType<String> canBreak = root.getMap("minecraft:can_break");
                if (canBreak != null) {
                    ListType predicates = canBreak.getList("predicates", ObjectType.MAP);
                    if (predicates != null) {
                        int len = predicates.size();
                        for (int i2 = 0; i2 < len; ++i2) {
                            1.walkBlockPredicates(predicates.getMap(i2), fromVersion, toVersion);
                        }
                    }
                    1.walkBlockPredicates(canBreak, fromVersion, toVersion);
                }
                if ((canPlaceOn = root.getMap("minecraft:can_place_on")) != null) {
                    ListType predicates = canPlaceOn.getList("predicates", ObjectType.MAP);
                    if (predicates != null) {
                        int len = predicates.size();
                        for (int i3 = 0; i3 < len; ++i3) {
                            1.walkBlockPredicates(predicates.getMap(i3), fromVersion, toVersion);
                        }
                    }
                    1.walkBlockPredicates(canPlaceOn, fromVersion, toVersion);
                }
                WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, root, "minecraft:charged_projectiles", fromVersion, toVersion);
                WalkerUtils.convertListPath(MCTypeRegistry.ITEM_STACK, root, "minecraft:container", "item", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ENTITY, root, "minecraft:entity_data", fromVersion, toVersion);
                WalkerUtils.convertList(MCTypeRegistry.ITEM_NAME, root, "minecraft:pot_decorations", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, root, "minecraft:use_remainder", fromVersion, toVersion);
                MapType<String> equippable = root.getMap("minecraft:equippable");
                if (equippable != null) {
                    WalkerUtils.convert(MCTypeRegistry.ENTITY_NAME, equippable, "allowed_entities", fromVersion, toVersion);
                    WalkerUtils.convertList(MCTypeRegistry.ENTITY_NAME, equippable, "allowed_entities", fromVersion, toVersion);
                }
                return null;
            }
        });
        MCTypeRegistry.DATA_COMPONENTS.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(4059){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                Object convertsTo;
                MapType food = data.getMap("minecraft:food");
                if (food == null) {
                    return null;
                }
                TypeUtil typeUtil = data.getTypeUtil();
                float eatSeconds = food.getFloat("eat_seconds", 1.6f);
                ListType oldEffects = food.getList("effects", ObjectType.MAP);
                ListType newEffects = typeUtil.createEmptyList();
                if (oldEffects != null) {
                    int len = oldEffects.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        MapType oldEffect = oldEffects.getMap(i2);
                        MapType<String> newEffect = typeUtil.createEmptyMap();
                        newEffects.addMap(newEffect);
                        newEffect.setString("type", "minecraft:apply_effects");
                        Object oldEffectEffect = oldEffect.getGeneric("effect");
                        ListType newEffectEffects = typeUtil.createEmptyList();
                        newEffectEffects.addGeneric(oldEffectEffect);
                        newEffect.setList("effects", newEffectEffects);
                        newEffect.setFloat("probability", oldEffect.getFloat("probability", 1.0f));
                    }
                }
                if ((convertsTo = food.getGeneric("using_converts_to")) != null) {
                    data.setGeneric("minecraft:use_remainder", convertsTo);
                }
                food.remove("eat_seconds");
                food.remove("effects");
                food.remove("using_converts_to");
                MapType<String> consumable = typeUtil.createEmptyMap();
                data.setMap("minecraft:consumable", consumable);
                consumable.setFloat("consume_seconds", eatSeconds);
                consumable.setList("on_consume_effects", newEffects);
                return null;
            }
        });
    }

    private V4059() {
    }
}

