/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public final class V3809 {
    private static final int VERSION = 3809;

    public static void register() {
        DataConverter<MapType<String>, MapType<String>> slotConverter = new DataConverter<MapType<String>, MapType<String>>(3809){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                ListType items = data.getList("Items", ObjectType.MAP);
                if (items == null) {
                    return null;
                }
                int len = items.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    MapType item = items.getMap(i2);
                    int slot = item.getInt("Slot", 2);
                    item.setByte("Slot", (byte)(slot - 2));
                }
                return null;
            }
        };
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:llama", slotConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:trader_llama", slotConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:mule", slotConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:donkey", slotConverter);
    }

    private V3809() {
    }
}

