/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V106 {
    private static final int VERSION = 106;

    public static void register() {
        MCTypeRegistry.UNTAGGED_SPAWNER.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(106){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                ListType spawnPotentials;
                String entityId = data.getString("EntityId");
                if (entityId != null) {
                    data.remove("EntityId");
                    MapType<Object> spawnData = data.getMap("SpawnData");
                    if (spawnData == null) {
                        spawnData = Types.NBT.createEmptyMap();
                        data.setMap("SpawnData", spawnData);
                    }
                    spawnData.setString("id", entityId.isEmpty() ? "Pig" : entityId);
                }
                if ((spawnPotentials = data.getList("SpawnPotentials", ObjectType.MAP)) != null) {
                    int len = spawnPotentials.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        MapType spawn = spawnPotentials.getMap(i2);
                        String spawnType = spawn.getString("Type");
                        if (spawnType == null) continue;
                        spawn.remove("Type");
                        MapType<Object> properties = spawn.getMap("Properties");
                        if (properties == null) {
                            properties = Types.NBT.createEmptyMap();
                        } else {
                            spawn.remove("Properties");
                        }
                        properties.setString("id", spawnType);
                        spawn.setMap("Entity", properties);
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.UNTAGGED_SPAWNER.addStructureWalker(106, (data, fromVersion, toVersion) -> {
            ListType spawnPotentials = data.getList("SpawnPotentials", ObjectType.MAP);
            if (spawnPotentials != null) {
                int len = spawnPotentials.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    MapType<String> spawnPotential = spawnPotentials.getMap(i2);
                    WalkerUtils.convert(MCTypeRegistry.ENTITY, spawnPotential, "Entity", fromVersion, toVersion);
                }
            }
            WalkerUtils.convert(MCTypeRegistry.ENTITY, (MapType<String>)data, "SpawnData", fromVersion, toVersion);
            return null;
        });
    }

    private V106() {
    }
}

