/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.datatypes;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.converters.datatypes.DataHook;
import ca.spottedleaf.dataconverter.converters.datatypes.DataType;
import ca.spottedleaf.dataconverter.converters.datatypes.DataWalker;
import ca.spottedleaf.dataconverter.minecraft.MCVersionRegistry;
import ca.spottedleaf.dataconverter.util.Long2ObjectArraySortedMap;
import java.util.ArrayList;
import java.util.List;

public class DynamicDataType
extends DataType<Object, Object> {
    public final String name;
    protected final ArrayList<DataConverter<Object, Object>> structureConverters = new ArrayList();
    protected final Long2ObjectArraySortedMap<List<DataWalker<Object>>> structureWalkers = new Long2ObjectArraySortedMap();
    protected final Long2ObjectArraySortedMap<List<DataHook<Object, Object>>> structureHooks = new Long2ObjectArraySortedMap();

    public DynamicDataType(String name) {
        this.name = name;
    }

    public void addStructureConverter(DataConverter<Object, Object> converter) {
        MCVersionRegistry.checkVersion(converter.getEncodedVersion());
        this.structureConverters.add(converter);
        this.structureConverters.sort(DataConverter.LOWEST_VERSION_COMPARATOR);
    }

    public void addStructureWalker(int minVersion, DataWalker<Object> walker) {
        this.addStructureWalker(minVersion, 0, walker);
    }

    public void addStructureWalker(int minVersion, int versionStep, DataWalker<Object> walker) {
        this.structureWalkers.computeIfAbsent(DataConverter.encodeVersions(minVersion, versionStep), keyInMap -> new ArrayList()).add(walker);
    }

    public void addStructureHook(int minVersion, DataHook<Object, Object> hook) {
        this.addStructureHook(minVersion, 0, hook);
    }

    public void addStructureHook(int minVersion, int versionStep, DataHook<Object, Object> hook) {
        this.structureHooks.computeIfAbsent(DataConverter.encodeVersions(minVersion, versionStep), keyInMap -> new ArrayList()).add(hook);
    }

    @Override
    public Object convert(Object data, long fromVersion, long toVersion) {
        List<DataWalker<Object>> walkers;
        List<DataHook<Object, Object>> hooks;
        Object ret = null;
        ArrayList<DataConverter<Object, Object>> converters = this.structureConverters;
        int len = converters.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Object replace;
            int klen;
            DataConverter converter = (DataConverter)converters.get(i2);
            long converterVersion = converter.getEncodedVersion();
            if (converterVersion <= fromVersion) continue;
            if (converterVersion > toVersion) break;
            List<DataHook<Object, Object>> hooks2 = this.structureHooks.getFloor(converterVersion);
            if (hooks2 != null) {
                klen = hooks2.size();
                for (int k2 = 0; k2 < klen; ++k2) {
                    Object replace2 = hooks2.get(k2).preHook(data, fromVersion, toVersion);
                    if (replace2 == null) continue;
                    ret = data = replace2;
                }
            }
            if ((replace = converter.convert(data, fromVersion, toVersion)) != null) {
                ret = data = replace;
            }
            if ((hooks2 = this.structureHooks.getFloor(toVersion)) == null) continue;
            klen = hooks2.size();
            for (int k3 = klen - 1; k3 >= 0; --k3) {
                Object postReplace = hooks2.get(k3).postHook(data, fromVersion, toVersion);
                if (postReplace == null) continue;
                ret = data = postReplace;
            }
        }
        if ((hooks = this.structureHooks.getFloor(toVersion)) != null) {
            int klen = hooks.size();
            for (int k4 = 0; k4 < klen; ++k4) {
                Object replace = hooks.get(k4).preHook(data, fromVersion, toVersion);
                if (replace == null) continue;
                ret = data = replace;
            }
        }
        if ((walkers = this.structureWalkers.getFloor(toVersion)) != null) {
            int len2 = walkers.size();
            for (int i3 = 0; i3 < len2; ++i3) {
                Object replace = walkers.get(i3).walk(data, fromVersion, toVersion);
                if (replace == null) continue;
                ret = data = replace;
            }
        }
        if (hooks != null) {
            int klen = hooks.size();
            for (int k5 = klen - 1; k5 >= 0; --k5) {
                Object postReplace = hooks.get(k5).postHook(data, fromVersion, toVersion);
                if (postReplace == null) continue;
                ret = data = postReplace;
            }
        }
        return ret;
    }
}

