/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.blockname;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.ConverterAbstractStringValueTypeRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.function.Function;

public final class ConverterAbstractBlockRename {
    private ConverterAbstractBlockRename() {
    }

    public static void register(int version, Function<String, String> renamer) {
        ConverterAbstractBlockRename.register(version, 0, renamer);
    }

    public static void register(int version, int subVersion, final Function<String, String> renamer) {
        ConverterAbstractStringValueTypeRename.register(version, subVersion, MCTypeRegistry.BLOCK_NAME, renamer);
        MCTypeRegistry.BLOCK_STATE.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(version, subVersion){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String converted;
                String name = data.getString("Name");
                if (name != null && (converted = (String)renamer.apply(name)) != null) {
                    data.setString("Name", converted);
                }
                return null;
            }
        });
        MCTypeRegistry.FLAT_BLOCK_STATE.addConverter(new DataConverter<Object, Object>(version, subVersion){

            @Override
            public Object convert(Object data, long sourceVersion, long toVersion) {
                String blockStateName;
                String converted;
                if (!(data instanceof String)) {
                    return null;
                }
                String string = (String)data;
                if (string.isEmpty()) {
                    return null;
                }
                int nbtStart1 = string.indexOf(91);
                int nbtStart2 = string.indexOf(123);
                int stateNameEnd = string.length();
                if (nbtStart1 > 0) {
                    stateNameEnd = nbtStart1;
                }
                if (nbtStart2 > 0) {
                    stateNameEnd = Math.min(stateNameEnd, nbtStart2);
                }
                if ((converted = (String)renamer.apply(blockStateName = string.substring(0, stateNameEnd))) == null) {
                    return null;
                }
                return converted.concat(string.substring(stateNameEnd));
            }
        });
    }
}

