/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util.hull;

import codes.wasabi.xclaim.map.util.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ConvexHull {
    public static List<Point> makeHull(List<Point> points) {
        ArrayList<Point> newPoints = new ArrayList<Point>(points);
        Collections.sort(newPoints);
        return ConvexHull.makeHullPresorted(newPoints);
    }

    public static List<Point> makeHullPresorted(List<Point> points) {
        if (points.size() <= 1) {
            return new ArrayList<Point>(points);
        }
        ArrayList<Point> upperHull = new ArrayList<Point>();
        for (Point p : points) {
            while (upperHull.size() >= 2) {
                Point q = (Point)upperHull.get(upperHull.size() - 1);
                Point r = (Point)upperHull.get(upperHull.size() - 2);
                if ((q.x() - r.x()) * (p.y() - r.y()) < (q.y() - r.y()) * (p.x() - r.x())) break;
                upperHull.remove(upperHull.size() - 1);
            }
            upperHull.add(p);
        }
        upperHull.remove(upperHull.size() - 1);
        ArrayList<Point> lowerHull = new ArrayList<Point>();
        for (int i = points.size() - 1; i >= 0; --i) {
            Point p = points.get(i);
            while (lowerHull.size() >= 2) {
                Point q = (Point)lowerHull.get(lowerHull.size() - 1);
                Point r = (Point)lowerHull.get(lowerHull.size() - 2);
                if ((q.x() - r.x()) * (p.y() - r.y()) < (q.y() - r.y()) * (p.x() - r.x())) break;
                lowerHull.remove(lowerHull.size() - 1);
            }
            lowerHull.add(p);
        }
        lowerHull.remove(lowerHull.size() - 1);
        if (upperHull.size() != 1 || !upperHull.equals(lowerHull)) {
            upperHull.addAll(lowerHull);
        }
        return upperHull;
    }
}

