/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class WeakLink<T> {
    private static final Method M_REFERS_TO;
    private static final boolean M_REFERS_TO_SUPPORT;
    private static final Method M_EQUALS;
    private static final boolean M_EQUALS_SUPPORT;
    protected Reference<T> reference = null;

    public WeakLink(@Nullable T initialValue) {
        if (initialValue != null) {
            this.set(initialValue);
        }
    }

    public WeakLink() {
        this(null);
    }

    public void set(@Nullable T value) {
        if (this.reference != null) {
            this.reference.clear();
        }
        if (value == null) {
            this.reference = null;
            return;
        }
        this.reference = M_REFERS_TO_SUPPORT ? new PhantomReference<T>(value, null) : new WeakReference<T>(value);
    }

    @Contract(value="null -> false")
    public boolean refersTo(@Nullable T referent) {
        if (referent == null || this.reference == null) {
            return false;
        }
        if (M_REFERS_TO_SUPPORT) {
            try {
                return (Boolean)M_REFERS_TO.invoke(this.reference, referent);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        T value = this.reference.get();
        if (M_EQUALS_SUPPORT) {
            try {
                return (Boolean)M_EQUALS.invoke(referent, value);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return referent.equals(value);
    }

    static {
        Method m = null;
        try {
            m = PhantomReference.class.getMethod("refersTo", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        M_REFERS_TO = m;
        M_REFERS_TO_SUPPORT = m != null;
        m = null;
        try {
            m = Object.class.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        M_EQUALS = m;
        M_EQUALS_SUPPORT = m != null;
    }
}

