/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class StreamUtil {
    public static byte[] readAllBytes(InputStream is, int bufferSize) throws IOException {
        int read;
        byte[] ret = new byte[]{};
        byte[] buffer = new byte[bufferSize];
        while ((read = is.read(buffer)) > 0) {
            int curLength = ret.length;
            byte[] concat = new byte[curLength + read];
            System.arraycopy(ret, 0, concat, 0, curLength);
            System.arraycopy(buffer, 0, concat, curLength, read);
            ret = concat;
        }
        return ret;
    }

    public static byte[] readAllBytes(InputStream is) throws IOException {
        return StreamUtil.readAllBytes(is, 8192);
    }

    public static byte[] readNBytes(InputStream is, int count) throws IOException {
        int r;
        byte[] ret = new byte[count];
        int off = 0;
        for (int len = count; len > 0; len -= r) {
            r = is.read(ret, off, len);
            if (r < 0) {
                throw new IOException("Unexpected end of stream");
            }
            off += r;
        }
        return ret;
    }

    public static void writeBytes(ByteArrayOutputStream bos, byte[] bytes) {
        try {
            bos.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

