/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util;

import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InventorySerializer {
    private static final byte[] zeroBytes = ByteBuffer.allocate(4).putInt(0).array();

    public static byte @NotNull [] serialize(@NotNull Inventory inventory) {
        return InventorySerializer.serialize(inventory.getContents());
    }

    public static byte @NotNull [] serialize(@Nullable ItemStack @NotNull [] inventory) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamUtil.writeBytes(bos, ByteBuffer.allocate(4).putInt(inventory.length).array());
        for (ItemStack is : inventory) {
            if (is == null) {
                StreamUtil.writeBytes(bos, zeroBytes);
                continue;
            }
            byte[] bytes = Platform.get().itemStackSerializeBytes(is);
            StreamUtil.writeBytes(bos, ByteBuffer.allocate(4).putInt(bytes.length).array());
            StreamUtil.writeBytes(bos, bytes);
        }
        return bos.toByteArray();
    }

    public static void deserialize(byte @NotNull [] bytes, @NotNull Inventory inventory) throws IllegalArgumentException {
        inventory.setContents(InventorySerializer.deserialize(bytes));
    }

    public static @Nullable ItemStack @NotNull [] deserialize(byte @NotNull [] bytes) throws IllegalArgumentException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            int length = ByteBuffer.wrap(StreamUtil.readNBytes(bis, 4)).getInt();
            ItemStack[] ret = new ItemStack[length];
            for (int i = 0; i < ret.length; ++i) {
                int len = ByteBuffer.wrap(StreamUtil.readNBytes(bis, 4)).getInt();
                if (len == 0) {
                    ret[i] = null;
                    continue;
                }
                byte[] bs = StreamUtil.readNBytes(bis, len);
                ret[i] = Platform.get().itemStackDeserializeBytes(bs);
            }
            return ret;
        }
        catch (IOException | BufferUnderflowException e) {
            throw new IllegalArgumentException("Malformed bytes", e);
        }
    }
}

