/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util;

import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.TextComponent;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.TextColor;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.TextDecoration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public final class DisplayItem {
    private static final Map<TextDecoration, TextDecoration.State> clearDecorations = new HashMap<TextDecoration, TextDecoration.State>();

    @NotNull
    public static ItemStack create(@NotNull Material material, @NotNull Component name, @NotNull List<Component> lore, int count) {
        ItemStack is = new ItemStack(material, count);
        ItemMeta meta = is.getItemMeta();
        if (meta != null) {
            Platform platform = Platform.get();
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_UNBREAKABLE});
            platform.metaDisplayName(meta, name);
            platform.metaLore(meta, lore);
        }
        is.setItemMeta(meta);
        return is;
    }

    @NotNull
    public static ItemStack create(@NotNull Material material, @NotNull Component name, @NotNull List<Component> lore) {
        return DisplayItem.create(material, name, lore, 1);
    }

    @NotNull
    public static ItemStack create(@NotNull Material material, @NotNull Component name, int count) {
        return DisplayItem.create(material, name, Collections.emptyList(), count);
    }

    @NotNull
    public static ItemStack create(@NotNull Material material, @NotNull Component name) {
        return DisplayItem.create(material, name, Collections.emptyList(), 1);
    }

    @NotNull
    public static ItemStack create(@NotNull Material material, @NotNull String name, @NotNull TextColor color, int count) {
        return DisplayItem.create(material, (Component)((TextComponent)Component.text(name).color(color)).decorations((Map)clearDecorations), Collections.emptyList(), count);
    }

    @NotNull
    public static ItemStack create(@NotNull Material material, @NotNull String name, @NotNull TextColor color) {
        return DisplayItem.create(material, (Component)((TextComponent)Component.text(name).color(color)).decorations((Map)clearDecorations), Collections.emptyList(), 1);
    }

    @NotNull
    public static ItemStack create(@NotNull Material material, @NotNull String name, int count) {
        return DisplayItem.create(material, (Component)Component.text(name).decorations((Map)clearDecorations), Collections.emptyList(), count);
    }

    @NotNull
    public static ItemStack create(@NotNull Material material, @NotNull String name) {
        return DisplayItem.create(material, (Component)Component.text(name).decorations((Map)clearDecorations), Collections.emptyList(), 1);
    }

    static {
        for (TextDecoration td : TextDecoration.values()) {
            clearDecorations.put(td, TextDecoration.State.FALSE);
        }
    }
}

