/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.protection.impl.worldguard;

import codes.wasabi.xclaim.protection.ProtectionRegion;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.RegionGroup;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Player;

public class WorldGuardProtectionRegion
implements ProtectionRegion {
    private static final Map<StateFlag, ProtectionRegion.Permission> permissionMap = Collections.unmodifiableMap(new HashMap<StateFlag, ProtectionRegion.Permission>(){
        {
            this.put(Flags.BUILD, ProtectionRegion.Permission.BUILD);
            this.put(Flags.BLOCK_BREAK, ProtectionRegion.Permission.BREAK);
            this.put(Flags.ENTRY, ProtectionRegion.Permission.ENTER);
            this.put(Flags.EXIT, ProtectionRegion.Permission.EXIT);
            this.put(Flags.USE, ProtectionRegion.Permission.USE);
            this.put(Flags.INTERACT, ProtectionRegion.Permission.INTERACT);
            this.put(Flags.PASSTHROUGH, ProtectionRegion.Permission.PASSTHROUGH);
        }
    });
    private final ProtectedRegion region;
    private final WorldGuardPlugin plugin;

    public WorldGuardProtectionRegion(ProtectedRegion region, WorldGuardPlugin plugin) {
        this.region = region;
        this.plugin = plugin;
    }

    public ProtectedRegion getHandle() {
        return this.region;
    }

    @Override
    public EnumSet<ProtectionRegion.Permission> getPermissions(Player player) {
        LocalPlayer lp = this.plugin.wrapPlayer(player);
        HashSet<ProtectionRegion.Permission> ret = new HashSet<ProtectionRegion.Permission>();
        Association association = lp.getAssociation(Collections.singletonList(this.region));
        for (Map.Entry<StateFlag, ProtectionRegion.Permission> entry : permissionMap.entrySet()) {
            if (!this.checkPermission(entry.getKey(), association)) continue;
            ret.add(entry.getValue());
        }
        return EnumSet.copyOf(ret);
    }

    private boolean checkPermission(StateFlag flag, Association association) {
        StateFlag.State state = (StateFlag.State)this.region.getFlag((Flag)flag);
        if (state == null) {
            return true;
        }
        RegionGroup group = (RegionGroup)this.region.getFlag((Flag)flag.getRegionGroupFlag());
        if (group == null) {
            return state == StateFlag.State.ALLOW || Objects.equals(association, Association.OWNER);
        }
        return state == StateFlag.State.ALLOW && group.contains(association) || Objects.equals(association, Association.OWNER);
    }
}

