/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.platform.paper_1_17;

import codes.wasabi.xclaim.platform.PlatformChatListener;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class PaperPlatformChatListener
implements PlatformChatListener {
    private final List<Consumer<PlatformChatListener.Data>> callbacks = new ArrayList<Consumer<PlatformChatListener.Data>>();
    private static final String nativePackage = new String(new char[]{'n', 'e', 't', '.', 'k', 'y', 'o', 'r', 'i', '.', 'a', 'd', 'v', 'e', 'n', 't', 'u', 'r', 'e'});
    private boolean nativeComponentInit = false;
    private Object nativeComponentSerializer;
    private Method nativeComponentSerialize;

    @Override
    public void onChat(Consumer<PlatformChatListener.Data> cb) {
        this.callbacks.add(cb);
    }

    @Override
    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
        this.callbacks.clear();
    }

    @EventHandler
    public void onMessage(@NotNull AsyncChatEvent event) {
        Object nativeComponent;
        try {
            Class<?> eventClass = event.getClass();
            Method m = eventClass.getMethod("originalMessage", new Class[0]);
            nativeComponent = m.invoke((Object)event, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String serialized = this.nativeComponentToPlainText(nativeComponent);
        if (serialized == null) {
            serialized = "";
        }
        PlatformChatListener.Data data = new PlatformChatListener.Data(event.getPlayer(), serialized, () -> event.setCancelled(true));
        for (Consumer<PlatformChatListener.Data> consumer : this.callbacks) {
            consumer.accept(data);
        }
    }

    private String nativeComponentToPlainText(Object nativeComponent) {
        if (!this.nativeComponentInit) {
            try {
                Class<?> clazz = nativeComponent.getClass();
                ClassLoader cl = clazz.getClassLoader();
                Class<?> serializerClass = Class.forName(this.getNativeClassName("text.serializer.plain.PlainTextComponentSerializer"), true, cl);
                Class<?> componentClass = Class.forName(this.getNativeClassName("text.Component"), true, cl);
                Method m = serializerClass.getDeclaredMethod("plainText", new Class[0]);
                Object serializer = m.invoke(null, new Object[0]);
                Method serializeMethod = serializerClass.getMethod("serialize", componentClass);
                this.nativeComponentSerializer = serializer;
                this.nativeComponentSerialize = serializeMethod;
                this.nativeComponentInit = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        String ret = null;
        try {
            ret = (String)this.nativeComponentSerialize.invoke(this.nativeComponentSerializer, nativeComponent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private String getNativeClassName(String path) {
        return nativePackage + "." + path;
    }
}

