/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.particle;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.particle.legacy.LegacyParticleService;
import codes.wasabi.xclaim.particle.legacy.LegacyParticleServiceReflection;
import codes.wasabi.xclaim.particle.paper.PaperParticleService;
import codes.wasabi.xclaim.particle.spigot.SpigotParticleService;
import codes.wasabi.xclaim.shadow.paperlib.PaperLib;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class ParticleService {
    private static boolean INIT = false;
    private static ParticleService INSTANCE = null;
    private static final String PLIB_PACKAGE = new String(new char[]{'x', 'y', 'z', '.', 'x', 'e', 'n', 'o', 'n', 'd', 'e', 'v', 's', '.', 'p', 'a', 'r', 't', 'i', 'c', 'l', 'e'});
    private static final String PLIB_URI = "https://repo1.maven.org/maven2/xyz/xenondevs/particle/1.8.4/particle-1.8.4.jar";

    public static void init() {
        if (!INIT) {
            try {
                if (PaperLib.isVersion(20)) {
                    INSTANCE = PaperLib.isPaper() ? new PaperParticleService() : new SpigotParticleService();
                } else {
                    LegacyParticleServiceReflection reflect = ParticleService.loadParticleLib();
                    INSTANCE = new LegacyParticleService(reflect);
                }
            }
            catch (Exception e) {
                XClaim.logger.log(Level.WARNING, "Failed to create preferred particle service", e);
                INSTANCE = new SpigotParticleService();
            }
        }
        INIT = true;
    }

    public static ParticleService get() {
        ParticleService.init();
        return INSTANCE;
    }

    private static LegacyParticleServiceReflection loadParticleLib() throws Exception {
        File destFile;
        File destDir = new File(XClaim.dataFolder, "lib");
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if (!(destFile = new File(destDir, "particle.jar")).exists()) {
            XClaim.logger.info(XClaim.lang.get("ext-dl"));
            try (FileOutputStream os = new FileOutputStream(destFile, false);){
                URL url = new URL(PLIB_URI);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Accept", "application/java-archive");
                conn.setRequestProperty("User-Agent", "XClaim; wasabithumbs@gmail.com");
                conn.setDoInput(true);
                conn.setDoOutput(false);
                try (InputStream is = conn.getInputStream();){
                    IOUtils.copyLarge(is, os);
                }
            }
        }
        URLClassLoader cl = new URLClassLoader(new URL[]{destFile.toURI().toURL()}, XClaim.class.getClassLoader());
        Class<?> builderClass = Class.forName(PLIB_PACKAGE + ".ParticleBuilder", true, cl);
        Class<?> effectClass = Class.forName(PLIB_PACKAGE + ".ParticleEffect", true, cl);
        Constructor<?> builderConstructor = builderClass.getConstructor(effectClass);
        Method builderSetColor = builderClass.getMethod("setColor", Color.class);
        Method builderSetLocation = builderClass.getMethod("setLocation", Location.class);
        Method builderSetAmount = builderClass.getMethod("setAmount", Integer.TYPE);
        Method builderSetOffset = builderClass.getMethod("setOffset", Float.TYPE, Float.TYPE, Float.TYPE);
        Method builderDisplay = builderClass.getMethod("display", Player[].class);
        return new LegacyParticleServiceReflection(builderClass, effectClass, builderConstructor, builderSetColor, builderSetLocation, builderSetAmount, builderSetOffset, builderDisplay);
    }

    public abstract void displayRedstoneParticle(Color var1, Location var2, int var3, float var4, float var5, float var6, Player var7);
}

