/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map.util;

import codes.wasabi.xclaim.map.util.ArrayBitmap;
import codes.wasabi.xclaim.map.util.Bitmap;
import codes.wasabi.xclaim.map.util.Point;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitmapTracer {
    private final Bitmap bitmap;
    private final ArrayBitmap traversed;

    public BitmapTracer(@NotNull Bitmap bitmap) {
        this.bitmap = bitmap;
        this.traversed = new ArrayBitmap(bitmap.getWidth(), bitmap.getHeight());
        for (int y = 0; y < bitmap.getHeight(); ++y) {
            for (int x = 0; x < bitmap.getWidth(); ++x) {
                if (bitmap.getPixel(x, y)) continue;
                this.traversed.setPixel(x, y);
            }
        }
    }

    @Nullable
    public List<List<Point>> poll() {
        List<Point> path;
        List<Line> lines = this.pollLines();
        if (lines == null) {
            return null;
        }
        LineGroup lineGroup = new LineGroup(lines, this.bitmap.getWidth());
        ArrayList<List<Point>> paths = new ArrayList<List<Point>>(1);
        while ((path = lineGroup.popLoopAsPoints()) != null) {
            paths.add(Collections.unmodifiableList(path));
        }
        return paths;
    }

    @Nullable
    private List<Line> pollLines() {
        Point coord = this.pollUnprocessed();
        if (coord == null) {
            return null;
        }
        LinkedList<Point> points = new LinkedList<Point>();
        points.add(coord);
        ArrayList<Line> ret = new ArrayList<Line>(4);
        while ((coord = (Point)points.poll()) != null) {
            this.pullLines(coord.x(), coord.y(), ret, points);
        }
        return ret;
    }

    private void pullLines(int x, int y, List<Line> lines, Queue<Point> queue) {
        if (this.traversed.getPixel(x, y)) {
            return;
        }
        this.traversed.setPixel(x, y);
        Line[] identity = new Line[4];
        int identityCount = 0;
        int ny = y;
        int nx = x - 1;
        if (this.bitmap.getPixel(nx, ny)) {
            queue.add(new Point(nx, ny));
        } else {
            identity[identityCount++] = new Line(x, y + 1, x, y, Line.Direction.LEFT);
        }
        nx = x + 1;
        if (this.bitmap.getPixel(nx, ny)) {
            queue.add(new Point(nx, ny));
        } else {
            identity[identityCount++] = new Line(x + 1, y, x + 1, y + 1, Line.Direction.RIGHT);
        }
        nx = x;
        ny = y - 1;
        if (this.bitmap.getPixel(nx, ny)) {
            queue.add(new Point(nx, ny));
        } else {
            identity[identityCount++] = new Line(x, y, x + 1, y, Line.Direction.UP);
        }
        ny = y + 1;
        if (this.bitmap.getPixel(nx, ny)) {
            queue.add(new Point(nx, ny));
        } else {
            identity[identityCount++] = new Line(x + 1, y + 1, x, y + 1, Line.Direction.DOWN);
        }
        if (identityCount != 0) {
            lines.addAll(Arrays.asList(identity).subList(0, identityCount));
        }
    }

    @Nullable
    private Point pollUnprocessed() {
        return this.traversed.firstUnset();
    }

    private static class LineGroup {
        private final List<Line> lines;
        private final int width;
        private final boolean[] traversed;
        private final Int2ObjectMap<IntList> starts;

        LineGroup(List<Line> lines, int width) {
            this.lines = lines;
            this.width = width <<= 2;
            this.traversed = new boolean[lines.size()];
            this.starts = new Int2ObjectLinkedOpenHashMap();
            for (int i = 0; i < lines.size(); ++i) {
                Point start = lines.get(i).a();
                int index = start.y() * width + start.x();
                ((IntList)this.starts.computeIfAbsent(index, ignored -> new IntArrayList(1))).add(i);
            }
        }

        @Nullable
        public List<Point> popLoopAsPoints() {
            final List<Line> lines = this.popLoop();
            if (lines == null) {
                return null;
            }
            final int size = lines.size();
            return new AbstractList<Point>(){

                @Override
                public Point get(int i) {
                    return ((Line)lines.get(i)).a();
                }

                @Override
                public int size() {
                    return size;
                }
            };
        }

        @Nullable
        List<Line> popLoop() {
            int nextIndex;
            IntList starting;
            int startIndex = -1;
            for (int i = 0; i < this.traversed.length; ++i) {
                if (this.traversed[i]) continue;
                startIndex = i;
                break;
            }
            if (startIndex == -1) {
                return null;
            }
            this.traversed[startIndex] = true;
            Line.Direction lastDirection = Line.Direction.RESERVED;
            Line cur = this.lines.get(startIndex);
            ArrayList<Line> ret = new ArrayList<Line>(this.traversed.length - startIndex);
            while ((starting = this.getStartingAt(cur.b().x(), cur.b().y())).size() != 0 && (nextIndex = starting.getInt(0)) != startIndex) {
                Line next = this.lines.get(nextIndex);
                this.traversed[nextIndex] = true;
                if (cur.direction != lastDirection) {
                    ret.add(cur);
                    lastDirection = cur.direction;
                }
                cur = next;
            }
            if (cur.direction != lastDirection) {
                ret.add(cur);
            }
            return ret;
        }

        @NotNull
        private IntList getStartingAt(int x, int y) {
            int index = y * this.width + x;
            IntList allStarts = (IntList)this.starts.get(index);
            if (allStarts == null) {
                return IntLists.emptyList();
            }
            int count = allStarts.size();
            IntArrayList nonTraversedStarts = new IntArrayList(count);
            for (int i = 0; i < count; ++i) {
                int start = allStarts.getInt(i);
                if (this.traversed[start]) continue;
                nonTraversedStarts.add(start);
            }
            return nonTraversedStarts;
        }
    }

    private static class Line
    extends codes.wasabi.xclaim.map.util.Line {
        private final Direction direction;

        Line(Point a, Point b, Direction direction) {
            super(a, b);
            this.direction = direction;
        }

        Line(int ax, int ay, int bx, int by, Direction direction) {
            this(new Point(ax, ay), new Point(bx, by), direction);
        }

        static enum Direction {
            RESERVED,
            LEFT,
            RIGHT,
            UP,
            DOWN;

        }
    }
}

