/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map.util;

import codes.wasabi.xclaim.map.util.BitmapTracer;
import codes.wasabi.xclaim.map.util.Point;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public interface Bitmap {
    public int getWidth();

    public int getHeight();

    public boolean getPixel(int var1, int var2);

    default public List<Point> trace() {
        List<List<Point>> lines = this.trace(false);
        if (lines.size() >= 1) {
            return lines.get(0);
        }
        return Collections.emptyList();
    }

    default public List<List<Point>> trace(boolean includeAll) {
        BitmapTracer tracer = new BitmapTracer(this);
        List<List<Point>> ret = tracer.poll();
        if (ret == null) {
            return Collections.emptyList();
        }
        if (includeAll) {
            ret.sort(Comparator.comparingInt(l -> l.size()).reversed());
            return ret;
        }
        List<Point> longest = null;
        int longestSize = 0;
        for (List<Point> candidate : ret) {
            int candidateSize = candidate.size();
            if (candidateSize <= longestSize) continue;
            longest = candidate;
            longestSize = candidateSize;
        }
        return longest == null ? Collections.emptyList() : Collections.singletonList(longest);
    }
}

