/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map.impl.dynmap;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.map.MapMarker;
import codes.wasabi.xclaim.map.util.ChunkBitmap;
import codes.wasabi.xclaim.map.util.ClaimUtil;
import codes.wasabi.xclaim.map.util.Point;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.util.ChunkReference;
import codes.wasabi.xclaim.util.hull.ConvexHull;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynmapMapMarker
implements MapMarker {
    private final AreaMarker marker;

    public DynmapMapMarker(AreaMarker marker) {
        this.marker = marker;
    }

    public AreaMarker get() {
        return this.marker;
    }

    @Override
    public void update(@NotNull Claim claim) {
        List<Object> points;
        int minHeight = 0;
        World w = claim.getWorld();
        if (w != null) {
            minHeight = Platform.get().getWorldMinHeight(w);
        }
        if (XClaim.mainConfig.integrations().map().oldOutlineStyle().booleanValue()) {
            points = new ArrayList();
            for (ChunkReference c : claim.getChunks()) {
                Location cornerBlock = c.getLocation(0.0, minHeight, 0.0);
                int cornerX = cornerBlock.getBlockX();
                int cornerZ = cornerBlock.getBlockZ();
                points.add(new Point(cornerX, cornerZ));
                points.add(new Point(cornerX + 16, cornerZ));
                points.add(new Point(cornerX, cornerZ + 16));
                points.add(new Point(cornerX + 16, cornerZ + 16));
            }
            points = ConvexHull.makeHull(points);
        } else {
            ChunkBitmap bmp = new ChunkBitmap(claim.getChunks());
            points = bmp.traceBlocks();
        }
        double[] xLocations = new double[points.size()];
        double[] zLocations = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            Point point = (Point)points.get(i);
            xLocations[i] = point.x();
            zLocations[i] = point.y();
        }
        this.marker.setCornerLocations(xLocations, zLocations);
    }

    @Override
    public void deleteMarker() {
        this.marker.deleteMarker();
    }

    @NotNull
    private static MarkerSet getMarkerSet(@NotNull DynmapAPI dynmap) {
        MarkerAPI api = dynmap.getMarkerAPI();
        MarkerSet ms = api.getMarkerSet("xclaim_marker_set");
        if (ms == null) {
            ms = api.createMarkerSet("xclaim_marker_set", XClaim.lang.get("dynmap-marker-name"), null, false);
        }
        return ms;
    }

    @Nullable
    static DynmapMapMarker getMarker(@NotNull DynmapAPI dynmap, @NotNull Claim claim) {
        String identifier;
        World w = claim.getWorld();
        if (w == null) {
            return null;
        }
        MarkerSet set = DynmapMapMarker.getMarkerSet(dynmap);
        AreaMarker marker = set.findAreaMarker(identifier = "claim_marker_" + claim.getUniqueToken());
        if (marker == null) {
            AreaMarker finalMarker = marker = set.createAreaMarker(identifier, claim.getName(), false, w.getName(), new double[]{0.0, 0.0}, new double[]{0.0, 0.0}, false);
            Consumer<Claim> updateColor = c -> {
                Color color = ClaimUtil.getClaimColor(c);
                int rgb = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
                finalMarker.setFillStyle(0.4, rgb);
                finalMarker.setLineStyle(3, 0.6, rgb);
            };
            updateColor.accept(claim);
            claim.onOwnerChanged(updateColor);
        }
        return new DynmapMapMarker(marker);
    }

    static void cleanMarkerSet(@NotNull DynmapAPI dynmap) {
        MarkerSet ms = DynmapMapMarker.getMarkerSet(dynmap);
        ms.deleteMarkerSet();
    }
}

