/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map.impl.bluemap;

import de.bluecolored.bluemap.api.BlueMapAPI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

class BluemapAPITracker {
    private final StampedLock stateLock = new StampedLock();
    private final LinkedList<Consumer<Object>> callbacks = new LinkedList();
    private boolean ready;
    private BlueMapAPI value;

    public BluemapAPITracker() {
        Optional current = BlueMapAPI.getInstance();
        if (current.isPresent()) {
            this.value = (BlueMapAPI)current.get();
            this.ready = true;
        } else {
            this.value = null;
            this.ready = false;
            BlueMapAPI.onEnable(this::setValue);
        }
        BlueMapAPI.onDisable(this::clearValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BlueMapAPI get() {
        long stamp = this.stateLock.readLock();
        try {
            BlueMapAPI blueMapAPI = this.value;
            return blueMapAPI;
        }
        finally {
            this.stateLock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void with(Consumer<Object> apiConsumer) {
        long stamp = this.stateLock.readLock();
        try {
            if (this.ready) {
                apiConsumer.accept(this.value);
            } else {
                stamp = this.stateLock.tryConvertToWriteLock(stamp);
                this.callbacks.add(apiConsumer);
            }
        }
        finally {
            this.stateLock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(BlueMapAPI api) {
        long stamp = this.stateLock.writeLock();
        try {
            boolean wasReady = this.ready;
            this.value = api;
            this.ready = true;
            if (wasReady) {
                return;
            }
            ArrayList<Consumer<Object>> callbacks = new ArrayList<Consumer<Object>>(this.callbacks);
            this.callbacks.clear();
            stamp = this.stateLock.tryConvertToReadLock(stamp);
            for (Consumer consumer : callbacks) {
                consumer.accept(api);
            }
        }
        finally {
            this.stateLock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearValue(BlueMapAPI api) {
        long stamp = this.stateLock.readLock();
        try {
            if (!Objects.equals(api, this.value)) {
                return;
            }
            stamp = this.stateLock.tryConvertToWriteLock(stamp);
            this.value = null;
            this.ready = false;
        }
        finally {
            this.stateLock.unlock(stamp);
        }
    }
}

