/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map;

import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.map.MapMarker;
import org.jetbrains.annotations.NotNull;

public interface MapServiceOp {
    @NotNull
    public static MapServiceOp update(@NotNull Claim claim) {
        return new Update(claim);
    }

    @NotNull
    public static MapServiceOp delete(@NotNull Claim claim) {
        return new Delete(claim);
    }

    @NotNull
    public Claim getClaim();

    public void apply(@NotNull MapMarker var1);

    public static final class Update
    implements MapServiceOp {
        private final Claim claim;

        public Update(Claim claim) {
            this.claim = claim;
        }

        @Override
        @NotNull
        public Claim getClaim() {
            return this.claim;
        }

        @Override
        public void apply(@NotNull MapMarker marker) {
            marker.update(this.claim);
        }
    }

    public static final class Delete
    implements MapServiceOp {
        private final Claim claim;

        public Delete(Claim claim) {
            this.claim = claim;
        }

        @Override
        @NotNull
        public Claim getClaim() {
            return this.claim;
        }

        @Override
        public void apply(@NotNull MapMarker marker) {
            marker.deleteMarker();
        }
    }
}

