/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.map.MapMarker;
import codes.wasabi.xclaim.map.MapServiceOp;
import codes.wasabi.xclaim.map.exception.MapServiceInitException;
import codes.wasabi.xclaim.map.impl.bluemap.BluemapMapService;
import codes.wasabi.xclaim.map.impl.dynmap.DynmapMapService;
import codes.wasabi.xclaim.util.service.ServiceFactory;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MapService {
    private static MapService instance = null;
    private static boolean instanceInit = false;
    private static boolean instanceValid = false;

    @Nullable
    public static MapService get() {
        if (instanceInit) {
            return instance;
        }
        if (!XClaim.mainConfig.integrations().map().enabled().booleanValue()) {
            instanceValid = false;
            instanceInit = true;
            return null;
        }
        ServiceFactory factory = new ServiceFactory(BluemapMapService.class, DynmapMapService.class);
        instance = (MapService)factory.createElseNull(XClaim.mainConfig.integrations().map().debug());
        instanceValid = instance != null;
        instanceInit = true;
        return instance;
    }

    @NotNull
    public static MapService getNonNull() {
        if (!instanceInit) {
            MapService.get();
        }
        return Objects.requireNonNull(instance);
    }

    public static boolean isAvailable() {
        if (!instanceInit) {
            MapService.get();
        }
        return instanceValid;
    }

    public static void unload() {
        MapService oldInstance = instance;
        boolean oldValid = instanceValid;
        instanceValid = false;
        instance = null;
        instanceInit = true;
        if (oldValid) {
            oldInstance.cleanup();
        }
    }

    protected MapService() throws MapServiceInitException {
    }

    @Nullable
    public abstract MapMarker getMarker(@NotNull Claim var1);

    public void queueOperation(@NotNull MapServiceOp op) {
        MapMarker marker = this.getMarker(op.getClaim());
        if (marker != null) {
            op.apply(marker);
        }
    }

    public abstract void cleanup();

    @NotNull
    protected final Plugin findPlugin(String name) throws MapServiceInitException {
        Plugin plug = Bukkit.getPluginManager().getPlugin(name);
        if (plug == null) {
            throw new MapServiceInitException("Failed to find plugin \"" + name + "\"");
        }
        if (!plug.isEnabled()) {
            throw new MapServiceInitException("Plugin \"" + name + "\" is not enabled");
        }
        return plug;
    }

    @NotNull
    protected final <T> Class<? extends T> findClass(String name, Class<T> superclass) throws MapServiceInitException {
        try {
            Class<?> ret = Class.forName(name);
            if (superclass.isAssignableFrom(ret)) {
                return ret.asSubclass(superclass);
            }
            throw new MapServiceInitException("Class \"" + name + "\" is not a subclass of \"" + superclass.getName() + "\"");
        }
        catch (ReflectiveOperationException e) {
            throw new MapServiceInitException("Failed to find class \"" + name + "\"");
        }
        catch (LinkageError e) {
            e.printStackTrace();
            throw new MapServiceInitException("Unexpected linkage error occurred while finding class \"" + name + "\"");
        }
    }
}

