/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.spec.impl.derived;

import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.enums.TrustLevel;
import codes.wasabi.xclaim.gui2.GuiInstance;
import codes.wasabi.xclaim.gui2.action.GuiAction;
import codes.wasabi.xclaim.gui2.spec.GuiSpecs;
import codes.wasabi.xclaim.gui2.spec.impl.PermissionListGuiSpec;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.TextComponent;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.TextDecoration;
import codes.wasabi.xclaim.util.DisplayItem;
import codes.wasabi.xclaim.util.WordWrap;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class GlobalPermissionListGuiSpec
extends PermissionListGuiSpec {
    public GlobalPermissionListGuiSpec(@NotNull Claim claim) {
        super(claim);
    }

    @Override
    @NotNull
    protected ItemStack populatePermission(@NotNull Permission perm) {
        NamedTextColor col;
        Material mat;
        TrustLevel tl = this.claim.getPermission(perm);
        switch (tl) {
            case NONE: {
                mat = Platform.get().getRedToken();
                col = NamedTextColor.RED;
                break;
            }
            case TRUSTED: {
                mat = Platform.get().getOrangeToken();
                col = NamedTextColor.GOLD;
                break;
            }
            case VETERANS: {
                mat = Platform.get().getYellowToken();
                col = NamedTextColor.YELLOW;
                break;
            }
            case ALL: {
                mat = Platform.get().getLimeToken();
                col = NamedTextColor.GREEN;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String s : WordWrap.wrap(perm.getDescription(), 25).split(System.lineSeparator())) {
            lore.add(((TextComponent)Component.text(s).color(NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        }
        return DisplayItem.create(mat, Component.text(perm.getPrintName()).color(col), lore);
    }

    @Override
    @NotNull
    protected GuiAction onClickPermission(@NotNull GuiInstance instance, @NotNull Permission permission) {
        return GuiAction.transfer(GuiSpecs.permissionLevels(this.claim, permission));
    }
}

