/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.spec.impl;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.gui2.GuiInstance;
import codes.wasabi.xclaim.gui2.action.GuiAction;
import codes.wasabi.xclaim.gui2.layout.GuiSlot;
import codes.wasabi.xclaim.gui2.spec.helper.PaginatedGuiSpec;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.util.ChunkReference;
import codes.wasabi.xclaim.util.DisplayItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClaimSelectorGuiSpec
extends PaginatedGuiSpec<Claim> {
    private static final ItemStack SEARCH_STACK = DisplayItem.create(Platform.get().getSpyglassMaterial(), XClaim.lang.getComponent("gui-sel-search"));
    protected Collection<Claim> entries = null;
    private Comparator<Claim> sort = null;

    @Override
    @NotNull
    public String layout() {
        return "claim-selector";
    }

    @Override
    @NotNull
    protected synchronized Collection<Claim> getEntries(@NotNull GuiInstance instance) {
        if (this.entries != null) {
            return this.entries;
        }
        Player player = instance.player();
        Set<Claim> all = Claim.getAll();
        if (player.isOp()) {
            this.entries = new HashSet<Claim>(all);
            return this.entries;
        }
        int sizeEstimate = Math.max(Math.floorDiv(all.size(), Bukkit.getOnlinePlayers().size() + 1), 8);
        ArrayList<Claim> entries = new ArrayList<Claim>(sizeEstimate);
        for (Claim c : all) {
            if (!this.canDisplay(c, player)) continue;
            entries.add(c);
        }
        this.entries = entries;
        return this.entries;
    }

    protected boolean canDisplay(@NotNull Claim claim, @NotNull Player player) {
        return claim.hasPermission((OfflinePlayer)player, this.requiredPermission());
    }

    @NotNull
    protected Permission requiredPermission() {
        return Permission.MANAGE;
    }

    @Override
    @NotNull
    protected final synchronized Comparator<Claim> getSort(@NotNull GuiInstance instance) {
        if (this.sort != null) {
            return this.sort;
        }
        Player player = instance.player();
        UUID id = player.getUniqueId();
        ChunkReference cr = ChunkReference.of(player.getLocation());
        this.sort = Comparator.comparingLong(c -> {
            long ret = c.minSquareDistance(cr);
            if (c.getOwner().getUniqueId().equals(id)) {
                ret |= Long.MIN_VALUE;
            }
            return ret;
        });
        return this.sort;
    }

    @Override
    protected int getContentSlot() {
        return 0;
    }

    @Override
    protected int getPreviousSlot() {
        return 1;
    }

    @Override
    @NotNull
    protected ItemStack getPreviousExtra() {
        return SEARCH_STACK;
    }

    @Override
    protected int getNextSlot() {
        return 3;
    }

    @Override
    protected int getBackSlot() {
        return 2;
    }

    @Override
    @Nullable
    protected ItemStack populateEntry(@NotNull GuiInstance instance, @NotNull Claim claim) {
        Component ownerName;
        XCPlayer owner = claim.getOwner();
        ChunkReference curChunk = ChunkReference.of(instance.player().getLocation());
        Player ownerOnline = owner.getPlayer();
        if (ownerOnline != null) {
            ownerName = Platform.get().playerDisplayName(ownerOnline);
        } else {
            String nm = owner.getName();
            if (nm == null) {
                nm = owner.getUniqueId().toString();
            }
            ownerName = Component.text(nm);
        }
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(XClaim.lang.getComponent("gui-sel-owned", ownerName));
        Set<ChunkReference> chunks = claim.getChunks();
        int chunkCount = chunks.size();
        if (chunkCount == 1) {
            lore.add(XClaim.lang.getComponent("gui-sel-chunk-count", chunkCount));
        } else {
            lore.add(XClaim.lang.getComponent("gui-sel-chunk-count-plural", chunkCount));
        }
        if (chunkCount > 0) {
            ChunkReference c = chunks.iterator().next();
            lore.add(XClaim.lang.getComponent("gui-sel-first-chunk", c.getCenterBlockX(), c.getCenterBlockZ()));
        }
        if (chunks.contains(curChunk)) {
            lore.add(XClaim.lang.getComponent("gui-sel-within"));
        }
        return DisplayItem.create(Platform.get().getGreenToken(), Component.text(claim.getName()).color(NamedTextColor.GREEN), lore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected GuiAction onClickEntry(@NotNull GuiInstance instance, @NotNull Claim entry) {
        if (!entry.isCanonical()) {
            ClaimSelectorGuiSpec claimSelectorGuiSpec = this;
            synchronized (claimSelectorGuiSpec) {
                this.entries = null;
            }
            return GuiAction.repopulate();
        }
        return this.onClickClaim(instance, entry);
    }

    @NotNull
    protected abstract GuiAction onClickClaim(@NotNull GuiInstance var1, @NotNull Claim var2);

    @Override
    @NotNull
    protected GuiAction onClickExtra(@NotNull GuiInstance instance, @NotNull GuiSlot slot, int index) {
        if (slot.index() == this.getPreviousSlot()) {
            return GuiAction.prompt(XClaim.lang.getComponent("gui-sel-prompt"));
        }
        return GuiAction.nothing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GuiAction onResponse(@NotNull GuiInstance instance, @NotNull String response) {
        LevenshteinDistance strDist = LevenshteinDistance.getDefaultInstance();
        ClaimSelectorGuiSpec claimSelectorGuiSpec = this;
        synchronized (claimSelectorGuiSpec) {
            this.sort = Comparator.comparingInt(c -> strDist.apply(c.getName(), response));
        }
        this.pagination.resetPage();
        return GuiAction.repopulate();
    }
}

