/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.spec.helper;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.gui2.GuiInstance;
import codes.wasabi.xclaim.gui2.action.GuiAction;
import codes.wasabi.xclaim.gui2.layout.GuiPagination;
import codes.wasabi.xclaim.gui2.layout.GuiSlot;
import codes.wasabi.xclaim.gui2.spec.GuiSpec;
import codes.wasabi.xclaim.gui2.spec.GuiSpecs;
import codes.wasabi.xclaim.util.DisplayItem;
import java.util.Collection;
import java.util.Comparator;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PaginatedGuiSpec<T>
implements GuiSpec {
    private static final ItemStack PREVIOUS_STACK = DisplayItem.create(Material.ARROW, XClaim.lang.getComponent("gui-comb-previous"));
    private static final ItemStack NEXT_STACK = DisplayItem.create(Material.ARROW, XClaim.lang.getComponent("gui-comb-next"));
    private static final ItemStack BACK_STACK = DisplayItem.create(Material.BARRIER, XClaim.lang.getComponent("gui-comb-back"));
    protected final GuiPagination<T> pagination = new GuiPagination();
    protected GuiPagination.State paginationState = GuiPagination.State.ONLY_PAGE;
    protected boolean queuedForce = false;

    @Override
    public void populate(@NotNull GuiInstance instance) {
        GuiPagination.State state = this.pagination.setSlot(this.getContentSlot()).setEntries(this.getEntries(instance), this.queuedForce).setSort(this.getSort(instance)).populate(instance, entry -> this.populateEntry(instance, entry));
        this.queuedForce = false;
        instance.set(this.getBackSlot(), BACK_STACK);
        instance.set(this.getPreviousSlot(), state.hasPrevious() ? PREVIOUS_STACK : this.getPreviousExtra());
        instance.set(this.getNextSlot(), state.hasNext() ? NEXT_STACK : this.getNextExtra());
        this.paginationState = state;
    }

    @Override
    @NotNull
    public GuiAction onClick(@NotNull GuiInstance instance, @NotNull GuiSlot slot, int index) {
        int sel = slot.index();
        if (sel == this.getContentSlot()) {
            T entry = this.pagination.click(instance, slot, index);
            if (entry != null) {
                return this.onClickEntry(instance, entry);
            }
        } else {
            if (sel == this.getBackSlot()) {
                return GuiAction.transfer(this.getReturn());
            }
            if (sel == this.getPreviousSlot()) {
                if (this.paginationState.hasPrevious()) {
                    this.pagination.previousPage();
                    return GuiAction.repopulate();
                }
            } else if (sel == this.getNextSlot() && this.paginationState.hasNext()) {
                this.pagination.nextPage();
                return GuiAction.repopulate();
            }
        }
        return this.onClickExtra(instance, slot, index);
    }

    @NotNull
    protected abstract Collection<T> getEntries(@NotNull GuiInstance var1);

    @Nullable
    protected Comparator<T> getSort(@NotNull GuiInstance instance) {
        return null;
    }

    protected abstract int getContentSlot();

    protected abstract int getPreviousSlot();

    @Nullable
    protected ItemStack getPreviousExtra() {
        return null;
    }

    protected abstract int getNextSlot();

    @Nullable
    protected ItemStack getNextExtra() {
        return null;
    }

    protected abstract int getBackSlot();

    @Nullable
    protected abstract ItemStack populateEntry(@NotNull GuiInstance var1, @NotNull T var2);

    @NotNull
    protected abstract GuiAction onClickEntry(@NotNull GuiInstance var1, @NotNull T var2);

    @NotNull
    protected GuiAction onClickExtra(@NotNull GuiInstance instance, @NotNull GuiSlot slot, int index) {
        return GuiAction.nothing();
    }

    @NotNull
    protected GuiSpec getReturn() {
        return GuiSpecs.main();
    }

    protected final void markForceUpdate() {
        this.queuedForce = true;
    }
}

