/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.spec;

import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.gui2.spec.GuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.ClearAllGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.MainGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.NewClaimGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.PermissionLevelsGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.PermissionOverviewGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.TransferOwnerGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.VersionInfoGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.derived.DeletingClaimSelectorGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.derived.EditChunksGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.derived.EditPermsGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.derived.EditTrustGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.derived.GlobalPermissionListGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.derived.IndividualPermissionListGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.derived.PermissiblePlayerListGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.derived.RenameClaimGuiSpec;
import codes.wasabi.xclaim.gui2.spec.impl.derived.TransferableClaimSelectorGuiSpec;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public final class GuiSpecs {
    private static final GuiSpec MAIN = new MainGuiSpec();
    private static final GuiSpec VERSION_INFO = new VersionInfoGuiSpec();
    private static final GuiSpec NEW_CLAIM = new NewClaimGuiSpec();

    @NotNull
    public static GuiSpec main() {
        return MAIN;
    }

    @NotNull
    public static GuiSpec versionInfo() {
        return VERSION_INFO;
    }

    @NotNull
    public static GuiSpec newClaim() {
        return NEW_CLAIM;
    }

    @NotNull
    public static GuiSpec editTrust() {
        return new EditTrustGuiSpec();
    }

    @NotNull
    public static GuiSpec editChunks() {
        return new EditChunksGuiSpec();
    }

    @NotNull
    public static GuiSpec renameClaim() {
        return new RenameClaimGuiSpec();
    }

    @NotNull
    public static GuiSpec editPerms() {
        return new EditPermsGuiSpec();
    }

    @NotNull
    public static GuiSpec permissionOverview(@NotNull Claim claim) {
        return new PermissionOverviewGuiSpec(claim);
    }

    @NotNull
    public static GuiSpec globalPermissionList(@NotNull Claim claim) {
        return new GlobalPermissionListGuiSpec(claim);
    }

    @NotNull
    public static GuiSpec permissionLevels(@NotNull Claim claim, @NotNull Permission permission) {
        return new PermissionLevelsGuiSpec(claim, permission);
    }

    @NotNull
    public static GuiSpec individualPermissionList(@NotNull Claim claim, @NotNull OfflinePlayer subject) {
        return new IndividualPermissionListGuiSpec(claim, subject);
    }

    @NotNull
    public static GuiSpec permissiblePlayerList(@NotNull Claim claim) {
        return new PermissiblePlayerListGuiSpec(claim);
    }

    @NotNull
    public static GuiSpec transferableClaimSelector() {
        return new TransferableClaimSelectorGuiSpec();
    }

    @NotNull
    public static GuiSpec transferOwner(@NotNull Claim claim, @NotNull OfflinePlayer target) {
        return new TransferOwnerGuiSpec(claim, target);
    }

    @NotNull
    public static GuiSpec clearAll() {
        return new ClearAllGuiSpec();
    }

    @NotNull
    public static GuiSpec deletingClaimSelector() {
        return new DeletingClaimSelectorGuiSpec();
    }
}

