/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.layout;

import codes.wasabi.xclaim.gui2.GuiInstance;
import codes.wasabi.xclaim.gui2.layout.GuiBasis;
import codes.wasabi.xclaim.gui2.layout.GuiSlot;
import codes.wasabi.xclaim.util.WeakLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiPagination<T> {
    private static final int F_ENTRIES_SET = 1;
    private static final int F_ENTRIES_SORTED = 2;
    private static final int F_SLOT_SET = 4;
    protected int page = 0;
    protected List<T> entries;
    protected int slot;
    private int flags = 0;
    private final WeakLink<Collection<T>> entriesSource = new WeakLink();
    private Comparator<T> sort = null;

    public synchronized void resetPage() {
        this.page = 0;
    }

    public synchronized void previousPage() {
        --this.page;
    }

    public synchronized void nextPage() {
        ++this.page;
    }

    @NotNull
    public synchronized State populate(@NotNull GuiInstance instance, @NotNull Function<T, ItemStack> mapper) {
        Data<T> data = this.getData(instance);
        if (data == null) {
            return State.ONLY_PAGE;
        }
        int count = data.values.size();
        int width = data.slot.width();
        int startSparse = Math.floorDiv(count, width) * width;
        for (int i = 0; i < startSparse; ++i) {
            instance.set(data.slot, i, mapper.apply(data.values.get(i)));
        }
        GuiBasis basis = data.slot.basis();
        int innerSize = count - startSparse;
        int head = 0;
        for (int i = startSparse; i < count; ++i) {
            instance.set(data.slot, startSparse + basis.organize(head++, innerSize, width), mapper.apply(data.values.get(i)));
        }
        return data.getState();
    }

    @Nullable
    public synchronized T click(@NotNull GuiInstance instance, @NotNull GuiSlot slot, int index) {
        Data<T> data = this.getData(instance);
        if (data == null) {
            return null;
        }
        if (data.slot.index() != slot.index()) {
            return null;
        }
        int count = data.values.size();
        if (index >= count) {
            return null;
        }
        int width = data.slot.width();
        int startSparse = Math.floorDiv(count, width) * width;
        if (index >= startSparse) {
            index = startSparse + data.slot.basis().unorganize(index - startSparse, count - startSparse, width);
        }
        return (T)data.values.get(index);
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public synchronized GuiPagination<T> setEntries(@NotNull Collection<T> entries, boolean force) {
        boolean move = true;
        if ((this.flags & 1) == 0) {
            this.flags |= 1;
        } else if (!force) {
            boolean bl = move = !this.entriesSource.refersTo(entries);
        }
        if (move) {
            this.entriesSource.set(entries);
            this.entries = new ArrayList<T>(entries);
            this.flags &= 0xFFFFFFFD;
        }
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public GuiPagination<T> setEntries(@NotNull Collection<T> entries) {
        return this.setEntries(entries, false);
    }

    @Contract(value="_ -> this")
    @NotNull
    public synchronized GuiPagination<T> setSlot(int slot) {
        this.slot = slot;
        this.flags |= 4;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public synchronized GuiPagination<T> setSort(@Nullable Comparator<T> sort) {
        if (Objects.equals(this.sort, sort)) {
            return this;
        }
        this.sort = sort;
        this.flags &= 0xFFFFFFFD;
        return this;
    }

    @Nullable
    private synchronized Data<T> getData(@NotNull GuiInstance instance) {
        this.validate();
        GuiSlot slot = instance.getSlot(this.slot);
        if (slot == null) {
            return null;
        }
        int capacity = slot.capacity();
        boolean empty = this.entries.isEmpty();
        int pageCount = empty ? 1 : Math.floorDiv(this.entries.size() - 1, capacity) + 1;
        int page = this.page;
        if (page < 0) {
            page = 0;
            this.page = 0;
        } else if (page >= pageCount) {
            this.page = page = pageCount - 1;
        }
        int pageStart = page * capacity;
        int pageEnd = Math.min(pageStart + capacity, this.entries.size());
        return new Data(slot, capacity, pageCount, page, empty ? Collections.emptyList() : this.entries.subList(pageStart, pageEnd));
    }

    private synchronized void validate() throws IllegalStateException {
        if ((this.flags & 1) == 0) {
            throw new IllegalStateException("Entries must be set before using GuiPagination");
        }
        if ((this.flags & 2) == 0) {
            if (this.sort != null) {
                this.entries.sort(this.sort);
            }
            this.flags |= 2;
        }
        if ((this.flags & 4) == 0) {
            throw new IllegalStateException("Slot must be set before using GuiPagination");
        }
    }

    protected static class Data<Q> {
        GuiSlot slot;
        int capacity;
        int pageCount;
        int page;
        List<Q> values;

        Data(@NotNull GuiSlot slot, int capacity, int pageCount, int page, List<Q> values) {
            this.slot = slot;
            this.capacity = capacity;
            this.pageCount = pageCount;
            this.page = page;
            this.values = values;
        }

        @NotNull
        State getState() {
            return State.of(this.page, this.pageCount);
        }
    }

    public static enum State {
        ONLY_PAGE(0),
        FIRST_PAGE(1),
        LAST_PAGE(2),
        SOME_PAGE(3);

        private final byte value;

        @NotNull
        static State of(int pageIndex, int pageCount) {
            if (pageIndex == 0) {
                return pageIndex + 1 < pageCount ? FIRST_PAGE : ONLY_PAGE;
            }
            if (pageIndex == pageCount - 1) {
                return LAST_PAGE;
            }
            return SOME_PAGE;
        }

        private State(int value) {
            this.value = (byte)value;
        }

        public boolean hasPrevious() {
            return (this.value & 2) != 0;
        }

        public boolean hasNext() {
            return (this.value & 1) != 0;
        }
    }
}

