/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui.page;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.enums.TrustLevel;
import codes.wasabi.xclaim.api.event.XClaimEvent;
import codes.wasabi.xclaim.api.event.XClaimGrantUserPermissionEvent;
import codes.wasabi.xclaim.api.event.XClaimRevokeUserPermissionEvent;
import codes.wasabi.xclaim.api.event.XClaimSetPermissionEvent;
import codes.wasabi.xclaim.gui.GUIHandler;
import codes.wasabi.xclaim.gui.Page;
import codes.wasabi.xclaim.gui.page.MainPage;
import codes.wasabi.xclaim.gui.page.PlayerCombinatorPage;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.TextComponent;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.TextDecoration;
import codes.wasabi.xclaim.util.DisplayItem;
import codes.wasabi.xclaim.util.WordWrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class PermissionPage
extends Page {
    private static final ItemStack GLOBAL_STACK = DisplayItem.create(Material.BUCKET, XClaim.lang.getComponent("gui-perm-general"), Arrays.asList(XClaim.lang.getComponent("gui-perm-general-line1"), XClaim.lang.getComponent("gui-perm-general-line2"), XClaim.lang.getComponent("gui-perm-general-line3")));
    private static final ItemStack PLAYER_STACK = DisplayItem.create(Platform.get().getSkeletonSkullMaterial(), XClaim.lang.getComponent("gui-perm-player"), Arrays.asList(XClaim.lang.getComponent("gui-perm-player-line1"), XClaim.lang.getComponent("gui-perm-player-line2"), XClaim.lang.getComponent("gui-perm-player-line3"), XClaim.lang.getComponent("gui-perm-player-line4"), XClaim.lang.getComponent("gui-perm-player-line5")));
    private static final ItemStack BACK_STACK = DisplayItem.create(Material.BARRIER, XClaim.lang.getComponent("gui-perm-back"));
    private final Claim claim;
    private int subPage = 0;
    private final Map<Integer, Object> pickKeys = new HashMap<Integer, Object>();
    private Permission modifyingPermission;
    private OfflinePlayer managingPlayer;

    public PermissionPage(@NotNull GUIHandler parent, @NotNull Claim claim) {
        super(parent);
        this.claim = claim;
    }

    private void populate() {
        this.clear();
        switch (this.subPage) {
            case 0: {
                this.setItem(10, GLOBAL_STACK);
                this.setItem(13, PLAYER_STACK);
                this.setItem(16, BACK_STACK);
                break;
            }
            case 1: {
                this.pickKeys.clear();
                int i = 0;
                for (Permission p : Permission.values()) {
                    NamedTextColor col;
                    Material mat;
                    if (i > 17) break;
                    this.pickKeys.put(i, (Object)p);
                    TrustLevel tl = this.claim.getPermission(p);
                    switch (tl) {
                        case NONE: {
                            mat = Platform.get().getRedToken();
                            col = NamedTextColor.RED;
                            break;
                        }
                        case TRUSTED: {
                            mat = Platform.get().getOrangeToken();
                            col = NamedTextColor.GOLD;
                            break;
                        }
                        case VETERANS: {
                            mat = Platform.get().getYellowToken();
                            col = NamedTextColor.YELLOW;
                            break;
                        }
                        case ALL: {
                            mat = Platform.get().getLimeToken();
                            col = NamedTextColor.GREEN;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    ArrayList<Component> lore = new ArrayList<Component>();
                    for (String s : WordWrap.wrap(p.getDescription(), 25).split(System.lineSeparator())) {
                        lore.add(((TextComponent)Component.text(s).color(NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
                    }
                    this.setItem(i, DisplayItem.create(mat, Component.text(p.getPrintName()).color(col), lore));
                    ++i;
                }
                this.setItem(22, BACK_STACK);
                break;
            }
            case 2: {
                PlayerCombinatorPage combinator = new PlayerCombinatorPage(this.getParent()){

                    @Override
                    @NotNull
                    protected List<OfflinePlayer> getList() {
                        return PermissionPage.this.claim.getUserPermissions().keySet().stream().map(XCPlayer::getOfflinePlayer).collect(Collectors.toList());
                    }

                    @Override
                    protected void add(@NotNull OfflinePlayer ply) {
                        PermissionPage.this.claim.setUserPermission(ply, Permission.ENTER, true);
                    }

                    @Override
                    protected void remove(@NotNull OfflinePlayer ply) {
                        PermissionPage.this.claim.clearUserPermissions(ply);
                    }

                    @Override
                    protected void onSelect(@NotNull OfflinePlayer ply) {
                        this.switchPage(PermissionPage.this);
                        PermissionPage.this.managingPlayer = ply;
                        PermissionPage.this.subPage = 4;
                        PermissionPage.this.populate();
                    }

                    @Override
                    protected void goBack() {
                        this.switchPage(PermissionPage.this);
                    }
                };
                this.switchPage(combinator);
                break;
            }
            case 3: {
                ItemStack enchanted;
                ItemStack noneItem = DisplayItem.create(Platform.get().getRedToken(), XClaim.lang.getComponent("gui-perm-tl-none"), Arrays.asList(XClaim.lang.getComponent("gui-perm-tl-none-line1"), XClaim.lang.getComponent("gui-perm-tl-none-line2")));
                ItemStack trustedItem = DisplayItem.create(Platform.get().getOrangeToken(), XClaim.lang.getComponent("gui-perm-tl-trusted"), Arrays.asList(XClaim.lang.getComponent("gui-perm-tl-trusted-line1"), XClaim.lang.getComponent("gui-perm-tl-trusted-line2"), XClaim.lang.getComponent("gui-perm-tl-trusted-line3")));
                ItemStack vetItem = DisplayItem.create(Platform.get().getYellowToken(), XClaim.lang.getComponent("gui-perm-tl-veterans"), Arrays.asList(XClaim.lang.getComponent("gui-perm-tl-veterans-line1"), XClaim.lang.getComponent("gui-perm-tl-veterans-line2"), XClaim.lang.getComponent("gui-perm-tl-veterans-line3")));
                ItemStack allItem = DisplayItem.create(Platform.get().getLimeToken(), XClaim.lang.getComponent("gui-perm-tl-all"), Arrays.asList(XClaim.lang.getComponent("gui-perm-tl-all-line1"), XClaim.lang.getComponent("gui-perm-tl-all-line2")));
                TrustLevel curTrust = this.claim.getPermission(this.modifyingPermission);
                switch (curTrust) {
                    case ALL: {
                        enchanted = allItem;
                        break;
                    }
                    case VETERANS: {
                        enchanted = vetItem;
                        break;
                    }
                    case TRUSTED: {
                        enchanted = trustedItem;
                        break;
                    }
                    default: {
                        enchanted = noneItem;
                    }
                }
                ItemMeta meta = enchanted.getItemMeta();
                if (meta != null) {
                    meta.addEnchant(Enchantment.DAMAGE_ALL, 1, true);
                }
                enchanted.setItemMeta(meta);
                this.setItem(10, curTrust == TrustLevel.NONE ? enchanted : noneItem);
                this.setItem(12, curTrust == TrustLevel.TRUSTED ? enchanted : trustedItem);
                this.setItem(14, curTrust == TrustLevel.VETERANS ? enchanted : vetItem);
                this.setItem(16, curTrust == TrustLevel.ALL ? enchanted : allItem);
                break;
            }
            case 4: {
                UUID target = this.managingPlayer.getUniqueId();
                EnumSet<Permission> set = EnumSet.noneOf(Permission.class);
                for (Map.Entry<XCPlayer, EnumSet<Permission>> entry : this.claim.getUserPermissions().entrySet()) {
                    if (!entry.getKey().getUniqueId().equals(target)) continue;
                    set = entry.getValue();
                    break;
                }
                Iterator it = Arrays.stream(Permission.values()).iterator();
                this.pickKeys.clear();
                for (int i1 = 0; i1 < 18 && it.hasNext(); ++i1) {
                    Permission perm = (Permission)((Object)it.next());
                    boolean value = set.contains((Object)perm);
                    Component text = XClaim.lang.getComponent(value ? "gui-perm-enabled" : "gui-perm-disabled");
                    NamedTextColor tc = value ? NamedTextColor.GREEN : NamedTextColor.RED;
                    Material mat = value ? Platform.get().getLimeToken() : Platform.get().getRedToken();
                    this.setItem(i1, DisplayItem.create(mat, Component.text(perm.getPrintName()).color(tc), Collections.singletonList(text.color(NamedTextColor.GRAY))));
                    this.pickKeys.put(i1, (Object)perm);
                }
                this.setItem(22, BACK_STACK);
                break;
            }
            case 5: {
                this.setItem(11, DisplayItem.create(Platform.get().getGreenConcreteMaterial(), XClaim.lang.getComponent("gui-perm-enabled"), Arrays.asList(XClaim.lang.getComponent("gui-perm-enabled-line1"), XClaim.lang.getComponent("gui-perm-enabled-line2"))));
                this.setItem(15, DisplayItem.create(Platform.get().getRedConcreteMaterial(), XClaim.lang.getComponent("gui-perm-disabled"), Arrays.asList(XClaim.lang.getComponent("gui-perm-disabled-line1"), XClaim.lang.getComponent("gui-perm-disabled-line2"), XClaim.lang.getComponent("gui-perm-disabled-line3"))));
            }
        }
    }

    @Override
    public void onEnter() {
        this.subPage = 0;
        this.populate();
    }

    @Override
    public void onClick(int slot) {
        switch (this.subPage) {
            case 0: {
                if (slot == 10) {
                    this.subPage = 1;
                } else if (slot == 13) {
                    this.subPage = 2;
                } else {
                    if (slot != 16) break;
                    this.switchPage(new MainPage(this.getParent()));
                    break;
                }
                this.populate();
                break;
            }
            case 1: {
                if (slot == 22) {
                    this.subPage = 0;
                    this.populate();
                    break;
                }
                Object ob = this.pickKeys.get(slot);
                if (ob == null || !(ob instanceof Permission)) break;
                this.modifyingPermission = (Permission)((Object)ob);
                this.subPage = 3;
                this.populate();
                break;
            }
            case 3: {
                TrustLevel set;
                if (slot < 10 || slot > 16) break;
                switch (slot) {
                    case 10: {
                        set = TrustLevel.NONE;
                        break;
                    }
                    case 12: {
                        set = TrustLevel.TRUSTED;
                        break;
                    }
                    case 14: {
                        set = TrustLevel.VETERANS;
                        break;
                    }
                    case 16: {
                        set = TrustLevel.ALL;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (!XClaimEvent.dispatch(new XClaimSetPermissionEvent(this.getTarget(), this.claim, this.modifyingPermission, this.claim.getPermission(this.modifyingPermission), set))) break;
                this.claim.setPermission(this.modifyingPermission, set);
                this.subPage = 1;
                this.populate();
                break;
            }
            case 4: {
                Object match;
                if (slot == 22) {
                    this.subPage = 2;
                    this.populate();
                    break;
                }
                if (slot >= 18 || (match = this.pickKeys.get(slot)) == null || !(match instanceof Permission)) break;
                this.modifyingPermission = (Permission)((Object)match);
                this.subPage = 5;
                this.populate();
                break;
            }
            case 5: {
                boolean value;
                if (slot == 11) {
                    value = true;
                } else {
                    if (slot != 15) break;
                    value = false;
                }
                if (!XClaimEvent.dispatch(value ? new XClaimGrantUserPermissionEvent(this.getTarget(), this.claim, this.modifyingPermission, XCPlayer.of(this.managingPlayer)) : new XClaimRevokeUserPermissionEvent(this.getTarget(), this.claim, this.modifyingPermission, XCPlayer.of(this.managingPlayer)))) {
                    return;
                }
                this.claim.setUserPermission(this.managingPlayer, this.modifyingPermission, value);
                this.subPage = 4;
                this.populate();
            }
        }
    }
}

