/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui.page;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.api.event.XClaimCreateClaimEvent;
import codes.wasabi.xclaim.api.event.XClaimEvent;
import codes.wasabi.xclaim.gui.ChunkEditor;
import codes.wasabi.xclaim.gui.GUIHandler;
import codes.wasabi.xclaim.gui.Page;
import codes.wasabi.xclaim.gui.page.MainPage;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.protection.ProtectionRegion;
import codes.wasabi.xclaim.protection.ProtectionService;
import codes.wasabi.xclaim.util.DisplayItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NewClaimPage
extends Page {
    private static int head = 1;
    private static final ItemStack YES_STACK = DisplayItem.create(Platform.get().getGreenConcreteMaterial(), XClaim.lang.getComponent("gui-new-confirm"), Arrays.asList(XClaim.lang.getComponent("gui-new-confirm-line1"), XClaim.lang.getComponent("gui-new-confirm-line2"), XClaim.lang.getComponent("gui-new-confirm-line3")));
    private static final ItemStack NO_STACK = DisplayItem.create(Platform.get().getRedConcreteMaterial(), XClaim.lang.getComponent("gui-new-cancel"), Arrays.asList(XClaim.lang.getComponent("gui-new-cancel-line1"), XClaim.lang.getComponent("gui-new-cancel-line2")));

    private static int nextIndex() {
        AtomicInteger index = new AtomicInteger(head);
        Claim.getAll().stream().sorted(Comparator.comparing(Claim::getName)).forEachOrdered(c -> {
            String root = XClaim.lang.get("new-claim").toLowerCase(Locale.ROOT) + " #";
            String n = c.getName().toLowerCase(Locale.ROOT);
            if (n.startsWith(root)) {
                int num;
                String remainder = n.substring(root.length());
                try {
                    num = Integer.parseInt(remainder);
                }
                catch (NumberFormatException e) {
                    return;
                }
                int v = index.get();
                if (num == v) {
                    index.set(v + 1);
                }
            }
        });
        int idx = index.get();
        head = idx + 1;
        return idx;
    }

    public NewClaimPage(@NotNull GUIHandler parent) {
        super(parent);
    }

    @Override
    public void onEnter() {
        this.clear();
        this.setItem(11, YES_STACK);
        this.setItem(15, NO_STACK);
    }

    @Override
    public void onClick(int slot) {
        if (slot == 11) {
            Claim cur;
            Player ply = this.getTarget();
            Chunk chunk = ply.getLocation().getChunk();
            if (!XClaim.mainConfig.worlds().checkLists(chunk.getWorld())) {
                Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("gui-new-disallowed"));
                return;
            }
            if (ProtectionService.isAvailable()) {
                ProtectionService service = ProtectionService.getNonNull();
                Collection<ProtectionRegion> regions = service.getRegionsAt(chunk);
                boolean all = true;
                for (ProtectionRegion region : regions) {
                    EnumSet<ProtectionRegion.Permission> set = region.getPermissions(ply);
                    boolean access = Arrays.stream(ProtectionRegion.Permission.values()).allMatch(set::contains);
                    if (access) continue;
                    all = false;
                    break;
                }
                if (!all) {
                    Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-protection-deny"));
                    this.getParent().close();
                    return;
                }
            }
            if ((cur = Claim.getByChunk(chunk)) != null && !cur.getOwner().getUniqueId().equals(ply.getUniqueId()) && !ply.hasPermission("xclaim.override")) {
                Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("gui-new-claimed"));
                this.getParent().close();
                return;
            }
            UUID uuid = ply.getUniqueId();
            XCPlayer xcp = XCPlayer.of((OfflinePlayer)ply);
            int maxChunks = xcp.getMaxChunks();
            int maxClaims = xcp.getMaxClaims();
            int maxWorldClaims = xcp.getMaxClaimsInWorld();
            int curClaims = 0;
            int curChunks = 0;
            int curInWorld = 0;
            String curWorldName = ply.getWorld().getName();
            for (Claim c : Claim.getAll()) {
                if (!c.getOwner().getUniqueId().equals(uuid)) continue;
                ++curClaims;
                curChunks += c.getChunks().size();
                World w = c.getWorld();
                if (w == null || !w.getName().equals(curWorldName)) continue;
                ++curInWorld;
            }
            if (curClaims >= maxClaims || curInWorld >= maxWorldClaims) {
                Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("gui-new-max-claims"));
                this.getParent().close();
                return;
            }
            if (curChunks >= maxChunks) {
                Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("gui-new-max-chunks"));
                this.getParent().close();
                return;
            }
            if (ChunkEditor.violatesDistanceCheck(ply, chunk)) {
                Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-min-distance-deny"));
                this.getParent().close();
                return;
            }
            String name = XClaim.lang.get("new-claim") + " #" + NewClaimPage.nextIndex();
            Claim newClaim = new Claim(name, Collections.singleton(chunk), (OfflinePlayer)ply);
            if (!XClaimEvent.dispatch(new XClaimCreateClaimEvent(ply, newClaim))) {
                return;
            }
            newClaim.claim();
            Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("gui-new-success", name));
            ply.playSound(ply.getLocation(), Platform.get().getLevelSound(), 1.0f, 1.0f);
            this.getParent().close();
            if (XClaim.mainConfig.editor().startOnCreate().booleanValue()) {
                ChunkEditor.startEditing(ply, newClaim);
            }
        } else if (slot == 15) {
            this.switchPage(new MainPage(this.getParent()));
        }
    }
}

