/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.gui.Page;
import codes.wasabi.xclaim.gui.page.MainPage;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.platform.PlatformChatListener;
import codes.wasabi.xclaim.platform.PlatformSchedulerTask;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class GUIHandler
implements InventoryHolder,
Listener {
    private static final Set<GUIHandler> openHandlers = new CopyOnWriteArraySet<GUIHandler>();
    private final Player target;
    private final Inventory inventory;
    private Page page = null;
    private boolean open = true;
    private PlatformSchedulerTask tick = null;
    private boolean shouldTick = false;
    private final PlatformChatListener chatListener;

    public static void closeAll() {
        for (GUIHandler handler : openHandlers) {
            handler.close();
        }
    }

    public GUIHandler(@NotNull Player target) {
        this.target = target;
        this.inventory = Platform.get().createInventory(this, 27, XClaim.lang.getComponent("gui-name"));
        this.switchPage(new MainPage(this));
        target.openInventory(this.inventory);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)XClaim.instance);
        this.chatListener = Platform.get().onChat();
        this.chatListener.onChat(this::onMessage);
        openHandlers.add(this);
    }

    public boolean getShouldTick() {
        return this.shouldTick;
    }

    public void setShouldTick(boolean _tick) {
        if (_tick == this.shouldTick) {
            return;
        }
        if (_tick) {
            this.tick = Platform.get().getScheduler().runTaskTimer((Plugin)XClaim.instance, () -> {
                if (this.page != null) {
                    this.page.onTick();
                } else {
                    this.setShouldTick(false);
                }
            }, 0L, 1L);
            this.shouldTick = true;
        } else {
            if (this.tick != null) {
                this.tick.cancel();
            }
            this.shouldTick = false;
            this.tick = null;
        }
    }

    @Nullable
    public Page getActivePage() {
        return this.page;
    }

    public void switchPage(@Nullable Page page) {
        if (page == this.page) {
            return;
        }
        if (this.page != null) {
            this.page.onExit();
        }
        this.setShouldTick(false);
        this.page = page;
        if (page != null) {
            page.onEnter();
        } else {
            this.inventory.clear();
        }
        Player target = this.getTarget();
        target.playSound(target.getLocation(), Platform.get().getClickSound(), 1.0f, 1.0f);
    }

    @NotNull
    public Player getTarget() {
        return this.target;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        HandlerList.unregisterAll((Listener)this);
        Platform.get().closeInventory(this.inventory);
        this.chatListener.unregister();
        if (this.shouldTick) {
            this.shouldTick = false;
            if (this.tick != null) {
                this.tick.cancel();
            }
        }
        if (this.page != null) {
            this.page.onExit();
        }
        openHandlers.remove(this);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    private boolean check(@NotNull InventoryEvent event) {
        Inventory inv = event.getInventory();
        InventoryHolder holder = inv.getHolder();
        return Objects.equals(holder, this);
    }

    @EventHandler
    public void onClose(@NotNull InventoryCloseEvent event) {
        if (!this.check((InventoryEvent)event)) {
            return;
        }
        if (this.page != null && this.page.suspended) {
            return;
        }
        this.close();
    }

    @EventHandler
    public void onClick(@NotNull InventoryClickEvent event) {
        if (!this.check((InventoryEvent)event)) {
            return;
        }
        event.setCancelled(true);
        if (this.page != null) {
            this.page.onClick(event.getSlot());
        }
    }

    @EventHandler
    public void onDrag(@NotNull InventoryDragEvent event) {
        if (this.check((InventoryEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeave(@NotNull PlayerQuitEvent event) {
        if (!this.open) {
            return;
        }
        Player ply = event.getPlayer();
        if (ply.getUniqueId().equals(this.target.getUniqueId())) {
            this.close();
        }
    }

    public void onMessage(@NotNull PlatformChatListener.Data data) {
        if (!this.open) {
            return;
        }
        Player ply = data.ply();
        if (ply.getUniqueId().equals(this.target.getUniqueId()) && this.page != null && this.page.onMessage(data.message())) {
            data.cancel().run();
        }
    }
}

