/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.event.XClaimAddChunkToClaimEvent;
import codes.wasabi.xclaim.api.event.XClaimEvent;
import codes.wasabi.xclaim.api.event.XClaimRemoveChunkFromClaimEvent;
import codes.wasabi.xclaim.config.struct.sub.RulesConfig;
import codes.wasabi.xclaim.economy.Economy;
import codes.wasabi.xclaim.particle.ParticleBuilder;
import codes.wasabi.xclaim.particle.ParticleEffect;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.platform.PlatformItemPickupListener;
import codes.wasabi.xclaim.platform.PlatformNamespacedKey;
import codes.wasabi.xclaim.platform.PlatformPersistentDataContainer;
import codes.wasabi.xclaim.platform.PlatformPersistentDataType;
import codes.wasabi.xclaim.protection.ProtectionRegion;
import codes.wasabi.xclaim.protection.ProtectionService;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.TextComponent;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.TextColor;
import codes.wasabi.xclaim.util.AttributeUtil;
import codes.wasabi.xclaim.util.ChunkReference;
import codes.wasabi.xclaim.util.DisplayItem;
import codes.wasabi.xclaim.util.InventorySerializer;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkEditor {
    private static ItemStack CLAIM_STACK;
    private static ItemStack UNCLAIM_STACK;
    private static ItemStack QUIT_STACK;
    private static PlatformNamespacedKey KEY_FLAG;
    private static PlatformNamespacedKey KEY_NAME;
    private static PlatformNamespacedKey KEY_INVENTORY;
    private static Events EVENTS;
    private static boolean initialized;
    private static final Map<UUID, Claim> editingMap;

    @NotNull
    public static PlatformNamespacedKey getNameKey() {
        return KEY_NAME;
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        CLAIM_STACK = DisplayItem.create(Platform.get().getGreenToken(), XClaim.lang.getComponent("chunk-editor-claim"));
        UNCLAIM_STACK = DisplayItem.create(Platform.get().getRedToken(), XClaim.lang.getComponent("chunk-editor-unclaim"));
        QUIT_STACK = DisplayItem.create(Material.BARRIER, XClaim.lang.getComponent("chunk-editor-quit"));
        KEY_FLAG = Objects.requireNonNull(Platform.get().createNamespacedKey(XClaim.instance, "ce_flag"));
        KEY_NAME = Objects.requireNonNull(Platform.get().createNamespacedKey(XClaim.instance, "ce_name"));
        KEY_INVENTORY = Objects.requireNonNull(Platform.get().createNamespacedKey(XClaim.instance, "ce_inventory"));
        EVENTS = new Events();
        Bukkit.getPluginManager().registerEvents((Listener)EVENTS, (Plugin)XClaim.instance);
        EVENTS.tryRegisterConditionalEvents();
    }

    @Nullable
    public static Claim getEditing(@NotNull Player ply) {
        UUID uuid = ply.getUniqueId();
        Claim ret = null;
        if (!editingMap.containsKey(uuid)) {
            PlatformPersistentDataContainer pdc = Platform.get().getPersistentDataContainer((Entity)ply);
            if (pdc.has(KEY_FLAG, PlatformPersistentDataType.BYTE)) {
                String name;
                boolean flag;
                boolean bl = flag = pdc.getOrDefaultAssert(KEY_FLAG, PlatformPersistentDataType.BYTE, Byte.class, (byte)0) != 0;
                if (flag && (name = pdc.getAssert(KEY_NAME, PlatformPersistentDataType.STRING, String.class)) != null) {
                    ret = Claim.getByName(name);
                    editingMap.put(uuid, ret);
                }
            }
        } else {
            ret = editingMap.get(uuid);
        }
        return ret;
    }

    public static boolean startEditing(@NotNull Player ply, @NotNull Claim claim) {
        if (ChunkEditor.getEditing(ply) != null) {
            return false;
        }
        UUID uuid = ply.getUniqueId();
        PlatformPersistentDataContainer pdc = Platform.get().getPersistentDataContainer((Entity)ply);
        pdc.set(KEY_NAME, PlatformPersistentDataType.STRING, claim.getName());
        pdc.set(KEY_INVENTORY, PlatformPersistentDataType.BYTE_ARRAY, InventorySerializer.serialize((Inventory)ply.getInventory()));
        editingMap.put(uuid, claim);
        pdc.set(KEY_FLAG, PlatformPersistentDataType.BYTE, (byte)1);
        PlayerInventory inv = ply.getInventory();
        inv.clear();
        inv.setItem(1, CLAIM_STACK);
        inv.setItem(4, UNCLAIM_STACK);
        inv.setItem(7, QUIT_STACK);
        return true;
    }

    public static boolean stopEditing(@NotNull Player ply) {
        if (ChunkEditor.getEditing(ply) == null) {
            return false;
        }
        UUID uuid = ply.getUniqueId();
        PlatformPersistentDataContainer pdc = Platform.get().getPersistentDataContainer((Entity)ply);
        pdc.set(KEY_FLAG, PlatformPersistentDataType.BYTE, (byte)0);
        try {
            ply.getInventory().setContents(ChunkEditor.getRetainedInventory(ply));
        }
        catch (IllegalArgumentException e) {
            ply.getInventory().clear();
        }
        editingMap.remove(uuid);
        return true;
    }

    static ItemStack @NotNull [] getRetainedInventory(@NotNull Player ply) throws IllegalArgumentException {
        PlatformPersistentDataContainer pdc = Platform.get().getPersistentDataContainer((Entity)ply);
        byte[] inventoryData = pdc.getOrDefaultAssert(KEY_INVENTORY, PlatformPersistentDataType.BYTE_ARRAY, byte[].class, new byte[0]);
        return InventorySerializer.deserialize(inventoryData);
    }

    public static boolean violatesDistanceCheck(Player owner, Chunk chunk) {
        double minDistance = XClaim.mainConfig.rules().minDistance().intValue();
        if (minDistance < 1.0) {
            return false;
        }
        if (minDistance > 16.0) {
            minDistance = 16.0;
        }
        int range = (int)Math.ceil(minDistance);
        double minDistanceSqr = minDistance * minDistance;
        ChunkReference start = ChunkReference.ofChunk(chunk);
        for (int mX = -range; mX <= range; ++mX) {
            boolean xZero = mX == 0;
            for (int mZ = -range; mZ <= range; ++mZ) {
                Claim c;
                double distSqr;
                if (xZero && mZ == 0 || (distSqr = (double)(mX * mX + mZ * mZ)) > minDistanceSqr || (c = Claim.getByChunk(start.getRelative(mX, mZ))) == null || c.getOwner().getUniqueId().equals(owner.getUniqueId()) || c.hasPermission((OfflinePlayer)owner, Permission.MANAGE)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        initialized = false;
        editingMap = new HashMap<UUID, Claim>();
    }

    public static class Events
    implements Listener {
        private Events() {
            PlatformItemPickupListener listener = Platform.get().getItemPickupListener();
            listener.on(this::onPickup);
            listener.register();
        }

        void tryRegisterConditionalEvents() {
            String[] miscPlayerEvents;
            for (String className : miscPlayerEvents = new String[]{"io.papermc.paper.event.player.PlayerItemFrameChangeEvent", "org.bukkit.event.player.PlayerArmorStandManipulateEvent"}) {
                try {
                    this.registerMiscPlayerEvent(Class.forName(className).asSubclass(PlayerEvent.class));
                }
                catch (ClassCastException | ClassNotFoundException exception) {
                    // empty catch block
                }
            }
        }

        private void registerMiscPlayerEvent(@NotNull Class<? extends PlayerEvent> clazz) {
            Bukkit.getPluginManager().registerEvent(clazz, (Listener)this, EventPriority.NORMAL, (ignored, event) -> this.onMiscPlayerEvent((PlayerEvent)event), (Plugin)XClaim.instance);
        }

        @EventHandler
        public void onDrop(@NotNull PlayerDropItemEvent event) {
            Player ply = event.getPlayer();
            if (ChunkEditor.getEditing(ply) != null) {
                event.setCancelled(true);
            }
        }

        public void onPickup(Player ply, Runnable cancel) {
            if (ChunkEditor.getEditing(ply) != null) {
                cancel.run();
            }
        }

        @EventHandler
        public void onClick(@NotNull InventoryClickEvent event) {
            Inventory inv;
            Player ply;
            HumanEntity ent = event.getWhoClicked();
            if (ent instanceof Player && ChunkEditor.getEditing(ply = (Player)ent) != null && Objects.equals(inv = event.getClickedInventory(), ply.getInventory())) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onDrag(@NotNull InventoryDragEvent event) {
            Inventory inv;
            Player ply;
            HumanEntity ent = event.getWhoClicked();
            if (ent instanceof Player && ChunkEditor.getEditing(ply = (Player)ent) != null && Objects.equals(inv = event.getInventory(), ply.getInventory())) {
                event.setCancelled(true);
            }
        }

        private boolean checkInventory(@NotNull Inventory inv) {
            HumanEntity ent;
            if (inv instanceof PlayerInventory && (ent = ((PlayerInventory)inv).getHolder()) instanceof Player) {
                return ChunkEditor.getEditing((Player)ent) != null;
            }
            return false;
        }

        @EventHandler
        public void onMove(@NotNull InventoryMoveItemEvent event) {
            Inventory a = event.getSource();
            Inventory b = event.getDestination();
            if (this.checkInventory(a)) {
                event.setCancelled(true);
                return;
            }
            if (this.checkInventory(b)) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onInteract(@NotNull PlayerInteractEvent event) {
            Action action = event.getAction();
            if (action == Action.PHYSICAL) {
                return;
            }
            Player ply = event.getPlayer();
            Claim claim = ChunkEditor.getEditing(ply);
            if (claim != null) {
                event.setCancelled(true);
                PlayerInventory inv = ply.getInventory();
                int slot = inv.getHeldItemSlot();
                switch (slot) {
                    case 1: {
                        Chunk chunk = ply.getLocation().getChunk();
                        Claim existing = Claim.getByChunk(chunk);
                        if (!(existing == null || existing.getOwner().getUniqueId().equals(ply.getUniqueId()) || ply.hasPermission("xclaim.override") || ply.isOp())) {
                            Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-taken"));
                            break;
                        }
                        World w = claim.getWorld();
                        if (w != null && !w.getName().equalsIgnoreCase(chunk.getWorld().getName())) {
                            Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-wrong-world"));
                            break;
                        }
                        if (ProtectionService.isAvailable()) {
                            ProtectionService service = ProtectionService.getNonNull();
                            Collection<ProtectionRegion> regions = service.getRegionsAt(chunk);
                            boolean all = true;
                            for (ProtectionRegion region : regions) {
                                Iterator<ChunkReference> set = region.getPermissions(ply);
                                boolean access = Arrays.stream(ProtectionRegion.Permission.values()).allMatch(arg_0 -> set.contains(arg_0));
                                if (access) continue;
                                all = false;
                                break;
                            }
                            if (!all) {
                                Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-protection-deny"));
                                break;
                            }
                        }
                        if (ChunkEditor.violatesDistanceCheck(ply, chunk)) {
                            Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-min-distance-deny"));
                            break;
                        }
                        RulesConfig.PlacementRule placementRule = XClaim.mainConfig.rules().placement();
                        if (placementRule != RulesConfig.PlacementRule.NONE) {
                            boolean diagonals = placementRule == RulesConfig.PlacementRule.NEIGHBOR;
                            boolean nextTo = false;
                            int targetX = chunk.getX();
                            int targetZ = chunk.getZ();
                            for (ChunkReference c : claim.getChunks()) {
                                boolean downMatch;
                                boolean rightMatch;
                                int thisX = c.x;
                                int thisZ = c.z;
                                int leftX = thisX - 1;
                                int rightX = thisX + 1;
                                boolean leftMatch = targetX == leftX;
                                boolean bl = rightMatch = targetX == rightX;
                                if (targetZ == thisZ) {
                                    if (leftMatch) {
                                        nextTo = true;
                                        break;
                                    }
                                    if (rightMatch) {
                                        nextTo = true;
                                        break;
                                    }
                                }
                                int upZ = thisZ + 1;
                                int downZ = thisZ - 1;
                                boolean upMatch = targetZ == upZ;
                                boolean bl2 = downMatch = targetZ == downZ;
                                if (targetX == thisX) {
                                    if (upMatch) {
                                        nextTo = true;
                                        break;
                                    }
                                    if (downMatch) {
                                        nextTo = true;
                                        break;
                                    }
                                }
                                if (!diagonals) continue;
                                if (upMatch && (leftMatch || rightMatch)) {
                                    nextTo = true;
                                    break;
                                }
                                if (!downMatch || !leftMatch && !rightMatch) continue;
                                nextTo = true;
                                break;
                            }
                            if (!nextTo) {
                                Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-adjacent"));
                                break;
                            }
                        }
                        XCPlayer xcp = XCPlayer.of((OfflinePlayer)ply);
                        int numChunks = 0;
                        int maxChunks = xcp.getMaxChunks();
                        UUID uuid = ply.getUniqueId();
                        for (Claim c : Claim.getAll()) {
                            if (!c.getOwner().getUniqueId().equals(uuid)) continue;
                            numChunks += c.getChunks().size();
                        }
                        if (numChunks >= maxChunks) {
                            Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-max"));
                            break;
                        }
                        if (!XClaimEvent.dispatch(new XClaimAddChunkToClaimEvent(ply, claim, chunk))) {
                            return;
                        }
                        if (claim.addChunk(chunk)) {
                            if (Economy.isAvailable() && numChunks >= xcp.getFreeChunks()) {
                                Economy eco = Economy.getAssert();
                                double price = xcp.getClaimPrice();
                                if (price > 0.0) {
                                    BigDecimal bd = BigDecimal.valueOf(price);
                                    if (!eco.canAfford((OfflinePlayer)ply, bd)) {
                                        Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-cant-afford", eco.format(bd)));
                                        claim.removeChunk(chunk);
                                        break;
                                    }
                                    if (!eco.take((OfflinePlayer)ply, bd)) {
                                        Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-pay-fail", eco.format(bd)));
                                        claim.removeChunk(chunk);
                                        break;
                                    }
                                    Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-pay-success", eco.format(bd)));
                                }
                            }
                            Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-add", chunk.getX(), chunk.getZ()));
                            break;
                        }
                        Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-redundant-add"));
                        break;
                    }
                    case 4: {
                        Chunk chunk1 = ply.getLocation().getChunk();
                        if (!XClaimEvent.dispatch(new XClaimRemoveChunkFromClaimEvent(ply, claim, chunk1))) {
                            return;
                        }
                        if (claim.removeChunk(chunk1)) {
                            if (Economy.isAvailable()) {
                                Economy eco = Economy.getAssert();
                                XCPlayer xcp1 = XCPlayer.of((OfflinePlayer)ply);
                                int numChunks1 = 0;
                                UUID uuid1 = ply.getUniqueId();
                                for (Claim c : Claim.getAll()) {
                                    if (!c.getOwner().getUniqueId().equals(uuid1)) continue;
                                    numChunks1 += c.getChunks().size();
                                }
                                if (numChunks1 >= xcp1.getFreeChunks()) {
                                    BigDecimal bd = BigDecimal.valueOf(xcp1.getUnclaimReward());
                                    eco.give((OfflinePlayer)ply, bd);
                                    Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-reward", eco.format(bd)));
                                }
                            }
                            Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-remove"));
                            break;
                        }
                        Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("chunk-editor-redundant-remove"));
                        break;
                    }
                    case 7: {
                        ChunkEditor.stopEditing(ply);
                    }
                }
            }
        }

        @EventHandler
        public void onInteractEntity(@NotNull PlayerInteractEntityEvent event) {
            Player ply = event.getPlayer();
            if (ChunkEditor.getEditing(ply) != null) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onLeave(@NotNull PlayerQuitEvent event) {
            Player ply = event.getPlayer();
            if (XClaim.mainConfig.editor().stopOnLeave().booleanValue()) {
                ChunkEditor.stopEditing(ply);
            }
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onDeath(@NotNull PlayerDeathEvent event) {
            Player ply = event.getEntity();
            if (ChunkEditor.stopEditing(ply) && !Platform.get().worldKeepInventory(ply.getWorld())) {
                List drops = event.getDrops();
                drops.clear();
                drops.addAll(Arrays.asList(ply.getInventory().getContents()));
            }
        }

        @EventHandler
        public void onDamage(@NotNull EntityDamageEvent event) {
            Entity ent = event.getEntity();
            if (!(ent instanceof Player)) {
                return;
            }
            Player ply = (Player)ent;
            if (ChunkEditor.getEditing(ply) == null) {
                return;
            }
            ItemStack[] inventory = ChunkEditor.getRetainedInventory(ply);
            double damage = event.getDamage();
            try {
                damage = AttributeUtil.scaleDamage(damage, inventory.length > 36 ? inventory[36] : null, inventory.length > 37 ? inventory[37] : null, inventory.length > 38 ? inventory[38] : null, inventory.length > 39 ? inventory[39] : null);
            }
            catch (Throwable ignored) {
                damage *= 0.5;
            }
            event.setDamage(damage);
        }

        @EventHandler
        public void onMove(@NotNull PlayerMoveEvent event) {
            Player ply = event.getPlayer();
            Claim editing = ChunkEditor.getEditing(ply);
            if (editing != null) {
                Location from = event.getFrom();
                Location to = event.getTo();
                Chunk fromChunk = from.getChunk();
                Chunk toChunk = to.getChunk();
                if (toChunk.getX() != fromChunk.getX() || toChunk.getZ() != fromChunk.getZ()) {
                    String langUnknown;
                    int ownState = 0;
                    String ownerName = langUnknown = XClaim.lang.get("unknown");
                    if (editing.contains(to)) {
                        ownState = 1;
                    } else {
                        Claim cl = Claim.getByChunk(toChunk);
                        if (cl != null) {
                            XCPlayer xcp = cl.getOwner();
                            ownerName = xcp.getName();
                            if (ownerName == null) {
                                ownerName = langUnknown;
                            }
                            ownState = xcp.getUniqueId().equals(ply.getUniqueId()) ? 2 : 3;
                        }
                    }
                    org.bukkit.Color color = org.bukkit.Color.GRAY;
                    String refer = XClaim.lang.get("chunk-editor-info-open");
                    if (ownState == 1) {
                        color = org.bukkit.Color.GREEN;
                        refer = XClaim.lang.get("chunk-editor-info-claimed");
                    } else if (ownState == 2) {
                        color = org.bukkit.Color.YELLOW;
                        refer = XClaim.lang.get("chunk-editor-info-owned");
                    } else if (ownState == 3) {
                        color = org.bukkit.Color.RED;
                        refer = XClaim.lang.get("chunk-editor-info-taken", ownerName);
                    }
                    TextColor tc = TextColor.color(color.asRGB());
                    Platform.getAdventure().player(ply).sendMessage(((TextComponent)((TextComponent)Component.empty().append(XClaim.lang.getComponent("chunk-editor-info", toChunk.getX(), toChunk.getZ()))).append(Component.newline())).append(Component.text(refer).color(tc)));
                    ply.playSound(ply.getLocation(), Platform.get().getExpSound(), 1.0f, 1.0f);
                    Color awtColor = new Color(color.asRGB());
                    World w = toChunk.getWorld();
                    double eyeY = to.getY() + ply.getEyeHeight();
                    int targetY = Math.min(Math.max((int)Math.round(eyeY), Platform.get().getWorldMinHeight(w)), w.getMaxHeight() - 1);
                    for (int y = targetY - 2; y < targetY + 3; ++y) {
                        Location bPos;
                        Location aPos;
                        Location origin = toChunk.getBlock(0, y, 0).getLocation();
                        for (double x = 0.0; x <= 16.0; x += 0.5) {
                            aPos = origin.clone().add(x, 0.0, 0.0);
                            bPos = origin.clone().add(x, 0.0, 16.0);
                            new ParticleBuilder(ParticleEffect.REDSTONE).setColor(awtColor).setLocation(aPos).setAmount(1).setOffset(0.02f, 0.02f, 0.02f).display(ply);
                            new ParticleBuilder(ParticleEffect.REDSTONE).setColor(awtColor).setLocation(bPos).setAmount(1).setOffset(0.02f, 0.02f, 0.02f).display(ply);
                        }
                        for (double z = 0.0; z <= 16.0; z += 0.5) {
                            aPos = origin.clone().add(0.0, 0.0, z);
                            bPos = origin.clone().add(16.0, 0.0, z);
                            new ParticleBuilder(ParticleEffect.REDSTONE).setColor(awtColor).setLocation(aPos).setAmount(1).setOffset(0.02f, 0.02f, 0.02f).display(ply);
                            new ParticleBuilder(ParticleEffect.REDSTONE).setColor(awtColor).setLocation(bPos).setAmount(1).setOffset(0.02f, 0.02f, 0.02f).display(ply);
                        }
                    }
                }
            }
        }

        public void onMiscPlayerEvent(@NotNull PlayerEvent event) {
            Player ply = event.getPlayer();
            if (ChunkEditor.getEditing(ply) != null && event instanceof Cancellable) {
                ((Cancellable)event).setCancelled(true);
            }
        }
    }
}

