/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.economy;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.economy.impl.EssentialsEconomy;
import codes.wasabi.xclaim.economy.impl.VaultEconomy;
import java.math.BigDecimal;
import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Economy {
    private static boolean checked = false;
    private static boolean has = false;
    private static Economy instance = null;

    public static boolean isAvailable() {
        if (!checked) {
            Economy.get();
        }
        return has;
    }

    private static void internalGet() {
        try {
            instance = new VaultEconomy();
            return;
        }
        catch (Throwable throwable) {
            try {
                instance = new EssentialsEconomy();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return;
        }
    }

    @Nullable
    public static Economy get() {
        if (checked) {
            return instance;
        }
        checked = true;
        instance = null;
        if (XClaim.mainConfig.integrations().economy().enabled().booleanValue()) {
            Economy.internalGet();
        }
        has = instance != null;
        return instance;
    }

    @NotNull
    public static Economy getAssert() {
        return Objects.requireNonNull(Economy.get());
    }

    public abstract boolean canAfford(OfflinePlayer var1, BigDecimal var2);

    public abstract boolean give(OfflinePlayer var1, BigDecimal var2);

    public abstract boolean take(OfflinePlayer var1, BigDecimal var2);

    @NotNull
    public abstract String format(BigDecimal var1);

    public boolean transfer(OfflinePlayer from, OfflinePlayer to, BigDecimal amount) {
        if (this.take(from, amount)) {
            if (this.give(to, amount)) {
                return true;
            }
            this.give(from, amount);
        }
        return false;
    }
}

